/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.sso.starter;

import com.vaadin.flow.spring.security.VaadinWebSecurity;
import com.vaadin.sso.core.BackChannelLogoutFilter;
import dev.hilla.sso.starter.BackChannelLogoutSubscription;
import dev.hilla.sso.starter.BootstrapDataServiceListener;
import dev.hilla.sso.starter.SingleSignOnContext;
import dev.hilla.sso.starter.SingleSignOnProperties;
import jakarta.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@EnableWebSecurity
@Conditional(value={ClientsConfiguredCondition.class})
@ConditionalOnProperty(name={"auto-configure"}, prefix="hilla.sso", matchIfMissing=true)
@EnableConfigurationProperties(value={SingleSignOnProperties.class})
public class SingleSignOnConfiguration
extends VaadinWebSecurity {
    private final SingleSignOnProperties properties;
    private final BackChannelLogoutFilter backChannelLogoutFilter;
    private final SessionRegistry sessionRegistry;
    private final BackChannelLogoutSubscription backChannelLogoutSubscription;
    private final SingleSignOnContext singleSignOnContext;
    private final BootstrapDataServiceListener bootstrapDataServiceListener;

    public SingleSignOnConfiguration(SingleSignOnProperties properties, SessionRegistry sessionRegistry, ClientRegistrationRepository clientRegistrationRepository, ApplicationEventPublisher eventPublisher) {
        this.properties = properties;
        this.sessionRegistry = sessionRegistry;
        this.backChannelLogoutFilter = new BackChannelLogoutFilter(sessionRegistry, clientRegistrationRepository, eventPublisher);
        this.backChannelLogoutSubscription = new BackChannelLogoutSubscription();
        this.singleSignOnContext = new SingleSignOnContext(clientRegistrationRepository, properties, this.backChannelLogoutSubscription);
        this.bootstrapDataServiceListener = new BootstrapDataServiceListener(this.singleSignOnContext);
    }

    @Bean
    public BackChannelLogoutSubscription backChannelLogoutSubscription() {
        return this.backChannelLogoutSubscription;
    }

    @Bean
    public SingleSignOnContext singleSignOnContext() {
        return this.singleSignOnContext;
    }

    @Bean
    public BootstrapDataServiceListener bootstrapDataServiceListener() {
        return this.bootstrapDataServiceListener;
    }

    @Bean(name={"VaadinSecurityFilterChainBean"})
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)http.oauth2Login().loginPage(this.properties.getLoginRoute()).and()).logout().logoutSuccessUrl("/").and()).sessionManagement().sessionConcurrency(concurrency -> {
            concurrency.maximumSessions(this.properties.getMaximumConcurrentSessions());
            concurrency.sessionRegistry(this.sessionRegistry);
        });
        if (this.properties.isBackChannelLogout()) {
            this.backChannelLogoutFilter.setBackChannelLogoutRoute(this.properties.getBackChannelLogoutRoute());
            http.addFilterAfter((Filter)this.backChannelLogoutFilter, LogoutFilter.class);
            RequestMatcher matcher = this.backChannelLogoutFilter.getRequestMatcher();
            http.csrf().ignoringRequestMatchers(new RequestMatcher[]{matcher});
        }
        return (SecurityFilterChain)http.build();
    }
}

