/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.sso.starter;

import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import dev.hilla.sso.starter.SingleSignOnContext;
import dev.hilla.sso.starter.SingleSignOnData;
import java.io.Serializable;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class BootstrapDataServiceListener
implements VaadinServiceInitListener {
    static final String SCRIPT_STRING = "window.Hilla = window.Hilla || {};\nwindow.Hilla.SSO = JSON.parse(\"%s\");\n";
    private final SingleSignOnContext singleSignOnContext;

    public BootstrapDataServiceListener(SingleSignOnContext singleSignOnContext) {
        this.singleSignOnContext = singleSignOnContext;
    }

    public void serviceInit(ServiceInitEvent event) {
        event.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)indexHtmlResponse -> {
            SingleSignOnData data = this.singleSignOnContext.getSingleSignOnData();
            String script = SCRIPT_STRING.formatted(this.quotesEscaped(this.json(data)));
            Element scriptNode = indexHtmlResponse.getDocument().createElement("script").appendChild((Node)new DataNode(script));
            indexHtmlResponse.getDocument().body().appendChild((Node)scriptNode);
        });
    }

    private String json(Object o) {
        if (o == null) {
            return "null";
        }
        return JsonUtils.beanToJson((Object)o).toJson();
    }

    private String quotesEscaped(String s) {
        return s.replace("\"", "\\\"");
    }
}

