/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.testbench;

import com.vaadin.testbench.TestBenchElement;
import java.io.File;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class UploadManagerTester {
    private final TestBenchElement element;

    UploadManagerTester(TestBenchElement element) {
        this.element = element;
    }

    public double getMaxFiles() {
        Object result = this.executeScript("return arguments[0].manager.maxFiles", new Object[0]);
        if (result == null) {
            return Double.POSITIVE_INFINITY;
        }
        return ((Number)result).doubleValue();
    }

    public boolean isMaxFilesReached() {
        return (Boolean)this.executeScript("return arguments[0].manager.maxFilesReached", new Object[0]);
    }

    public int getFileCount() {
        return ((Number)this.executeScript("return arguments[0].manager.files.length", new Object[0])).intValue();
    }

    public void removeFile(int index) {
        this.executeScript("const file = arguments[0].manager.files[arguments[1]];if (file) arguments[0].manager.removeFile(file);", index);
    }

    public void uploadFiles() {
        this.executeScript("arguments[0].manager.uploadFiles()", new Object[0]);
    }

    public void abort() {
        this.executeScript("arguments[0].manager.files.forEach(f => { if (f.uploading) arguments[0].manager.abortUpload(f); })", new Object[0]);
    }

    public void waitForUploads(int maxSeconds) {
        new WebDriverWait(this.element.getDriver(), Duration.ofSeconds(maxSeconds)).until(driver -> (boolean)((Boolean)this.executeScript("return arguments[0].manager.files.every(f => !f.uploading)", new Object[0])));
    }

    public void upload(File file) {
        this.upload(file, 60);
    }

    public void upload(File file, int maxSeconds) {
        TestBenchElement fileInput = (TestBenchElement)this.executeScript("const input = document.createElement('input');input.type = 'file';input.style.position = 'absolute';input.style.left = '-9999px';document.body.appendChild(input);return input;", new Object[0]);
        if (!UploadManagerTester.isLocalDriver(this.element.getDriver())) {
            this.setLocalFileDetector(fileInput);
        }
        fileInput.sendKeys(new CharSequence[]{file.getPath()});
        this.executeScript("arguments[0].manager.addFiles(arguments[1].files);arguments[1].remove();", fileInput);
        if (maxSeconds > 0) {
            this.waitForUploads(maxSeconds);
        }
    }

    public void uploadMultiple(List<File> files, int maxSeconds) {
        for (File file : files) {
            this.upload(file, 0);
        }
        if (maxSeconds > 0) {
            this.waitForUploads(maxSeconds);
        }
    }

    private void setLocalFileDetector(TestBenchElement fileInput) {
        TestBenchElement realElement = fileInput;
        while (realElement instanceof WrapsElement) {
            WrapsElement wrapsElement = (WrapsElement)realElement;
            realElement = wrapsElement.getWrappedElement();
        }
        if (realElement instanceof RemoteWebElement) {
            RemoteWebElement remoteWebElement = (RemoteWebElement)realElement;
            remoteWebElement.setFileDetector((FileDetector)new LocalFileDetector());
        }
    }

    private static boolean isLocalDriver(WebDriver driver) {
        while (driver instanceof WrapsDriver) {
            WrapsDriver wrapsDriver = (WrapsDriver)driver;
            driver = wrapsDriver.getWrappedDriver();
        }
        return driver instanceof ChromiumDriver || driver instanceof FirefoxDriver || driver instanceof SafariDriver;
    }

    private Object executeScript(String script, Object ... args) {
        Object[] allArgs = new Object[args.length + 1];
        allArgs[0] = this.element;
        System.arraycopy(args, 0, allArgs, 1, args.length);
        return this.element.getCommandExecutor().executeScript(script, allArgs);
    }
}

