/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.upload.ModularUploadExperimentalFeatureException;
import com.vaadin.flow.component.upload.UploadFormat;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.streams.UploadCompleteEvent;
import com.vaadin.flow.internal.streams.UploadStartEvent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.server.streams.UploadResult;
import com.vaadin.flow.shared.Registration;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UploadManager
implements Serializable {
    private final Connector connector = new Connector();
    private final Component owner;
    private final AtomicInteger activeUploads = new AtomicInteger(0);
    private List<String> acceptedMimeTypes = List.of();
    private List<String> acceptedFileExtensions = List.of();
    private final AtomicBoolean handlerExplicitlyConfigured = new AtomicBoolean();
    public static final String FEATURE_FLAG_ID = "modularUpload";

    public UploadManager(Component owner) {
        this(owner, null);
    }

    public UploadManager(Component owner, UploadHandler handler) {
        Objects.requireNonNull(owner, "Owner component cannot be null");
        this.owner = owner;
        owner.getElement().appendVirtualChild(new Element[]{this.connector.getElement()});
        this.setUploadHandler((UploadHandler)(handler != null ? handler : new FailFastUploadHandler()));
        String eventDetailFileName = "event.detail.fileName";
        String eventDetailErrorMessage = "event.detail.errorMessage";
        this.connector.getElement().addEventListener("file-remove", (DomEventListener & Serializable)event -> {
            String fileName = event.getEventData().get("event.detail.fileName").asString();
            ComponentUtil.fireEvent((Component)owner, (ComponentEvent)new FileRemovedEvent(owner, true, fileName));
        }).addEventData("event.detail.fileName");
        this.connector.getElement().addEventListener("file-reject", (DomEventListener & Serializable)event -> {
            String fileName = event.getEventData().get("event.detail.fileName").asString();
            String errorCode = event.getEventData().get("event.detail.errorMessage").asString();
            FileRejectionReason reason = FileRejectionReason.fromClientCode(errorCode);
            ComponentUtil.fireEvent((Component)owner, (ComponentEvent)new FileRejectedEvent(owner, true, reason, fileName));
        }).addEventData("event.detail.fileName").addEventData("event.detail.errorMessage");
        this.connector.getElement().addEventListener("all-finished", (DomEventListener & Serializable)event -> ComponentUtil.fireEvent((Component)owner, (ComponentEvent)new AllFinishedEvent(owner)));
        ComponentUtil.addListener((Component)this.connector, UploadStartEvent.class, (ComponentEventListener & Serializable)event -> this.startUpload());
        ComponentUtil.addListener((Component)this.connector, UploadCompleteEvent.class, (ComponentEventListener & Serializable)event -> this.endUpload());
    }

    Connector getConnector() {
        return this.connector;
    }

    public void setUploadHandler(UploadHandler handler) {
        this.setUploadHandler(handler, "upload");
    }

    public void setUploadHandler(UploadHandler handler, final String targetName) {
        Objects.requireNonNull(handler, "UploadHandler cannot be null");
        Objects.requireNonNull(targetName, "The target name cannot be null");
        if (targetName.isBlank()) {
            throw new IllegalArgumentException("The target name cannot be blank");
        }
        if (!(handler instanceof FailFastUploadHandler)) {
            this.handlerExplicitlyConfigured.set(true);
        }
        UploadHandler validatingHandler = this.wrapWithFileTypeValidation(handler);
        StreamResourceRegistry.ElementStreamResource elementStreamResource = new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)validatingHandler, this.connector.getElement()){

            public String getName() {
                return targetName;
            }
        };
        this.connector.getElement().setAttribute("target", (AbstractStreamResource)elementStreamResource);
    }

    public void setMaxFiles(int maxFiles) {
        this.connector.getElement().setProperty("maxFiles", maxFiles == 0 ? Double.POSITIVE_INFINITY : (double)maxFiles);
    }

    public int getMaxFiles() {
        double value = this.connector.getElement().getProperty("maxFiles", 0.0);
        return Double.isInfinite(value) ? 0 : (int)value;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.connector.getElement().setProperty("maxFileSize", maxFileSize == 0L ? Double.POSITIVE_INFINITY : (double)maxFileSize);
    }

    public long getMaxFileSize() {
        double value = this.connector.getElement().getProperty("maxFileSize", 0.0);
        return Double.isInfinite(value) ? 0L : (long)value;
    }

    public void setAcceptedMimeTypes(String ... mimeTypes) {
        if (mimeTypes == null || mimeTypes.length == 0) {
            this.acceptedMimeTypes = List.of();
        } else {
            for (String mimeType : mimeTypes) {
                if (mimeType == null || mimeType.isBlank()) {
                    throw new IllegalArgumentException("MIME types cannot contain null or blank values");
                }
                if (mimeType.contains("/")) continue;
                throw new IllegalArgumentException("MIME type must contain a '/' character: " + mimeType);
            }
            this.acceptedMimeTypes = List.of(mimeTypes);
        }
        this.updateAcceptProperty();
    }

    public List<String> getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedFileExtensions(String ... extensions) {
        if (extensions == null || extensions.length == 0) {
            this.acceptedFileExtensions = List.of();
        } else {
            for (String ext : extensions) {
                if (ext == null || ext.isBlank()) {
                    throw new IllegalArgumentException("File extensions cannot contain null or blank values");
                }
                if (ext.startsWith(".")) continue;
                throw new IllegalArgumentException("File extension must start with '.': " + ext);
            }
            this.acceptedFileExtensions = List.of(extensions);
        }
        this.updateAcceptProperty();
    }

    public List<String> getAcceptedFileExtensions() {
        return this.acceptedFileExtensions;
    }

    private UploadHandler wrapWithFileTypeValidation(final UploadHandler delegate) {
        return new UploadHandler(){

            public void handleUploadRequest(UploadEvent event) throws IOException {
                List<String> mimeTypes = UploadManager.this.acceptedMimeTypes;
                List<String> extensions = UploadManager.this.acceptedFileExtensions;
                if (!(mimeTypes.isEmpty() && extensions.isEmpty() || UploadManager.isFileTypeAccepted(event.getFileName(), event.getContentType(), mimeTypes, extensions))) {
                    event.reject("File type not allowed: " + event.getFileName());
                    return;
                }
                delegate.handleUploadRequest(event);
            }

            public void responseHandled(UploadResult result) {
                delegate.responseHandled(result);
            }

            public long getRequestSizeMax() {
                return delegate.getRequestSizeMax();
            }

            public long getFileSizeMax() {
                return delegate.getFileSizeMax();
            }

            public long getFileCountMax() {
                return delegate.getFileCountMax();
            }

            public String getUrlPostfix() {
                return delegate.getUrlPostfix();
            }

            public boolean isAllowInert() {
                return delegate.isAllowInert();
            }

            public DisabledUpdateMode getDisabledUpdateMode() {
                return delegate.getDisabledUpdateMode();
            }
        };
    }

    private static boolean isFileTypeAccepted(String fileName, String contentType, List<String> mimeTypes, List<String> extensions) {
        if (!mimeTypes.isEmpty() && !UploadManager.matchesAnyMimeType(contentType, mimeTypes)) {
            return false;
        }
        return extensions.isEmpty() || UploadManager.matchesAnyExtension(fileName, extensions);
    }

    private static boolean matchesAnyMimeType(String contentType, List<String> mimeTypes) {
        for (String pattern : mimeTypes) {
            if (!UploadManager.matchesMimeType(contentType, pattern)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesAnyExtension(String fileName, List<String> extensions) {
        if (fileName == null) {
            return false;
        }
        String lowerFileName = fileName.toLowerCase(Locale.ENGLISH);
        for (String ext : extensions) {
            if (!lowerFileName.endsWith(ext.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesMimeType(String actual, String pattern) {
        if (actual == null || pattern == null) {
            return false;
        }
        int semicolonIndex = actual.indexOf(59);
        if (semicolonIndex >= 0) {
            actual = actual.substring(0, semicolonIndex).trim();
        }
        if (actual.equalsIgnoreCase(pattern)) {
            return true;
        }
        if (pattern.endsWith("/*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            return actual.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
        }
        return false;
    }

    private void updateAcceptProperty() {
        String accept = Stream.concat(this.acceptedMimeTypes.stream(), this.acceptedFileExtensions.stream()).collect(Collectors.joining(","));
        this.connector.getElement().setProperty("accept", accept);
    }

    public void setAutoUpload(boolean autoUpload) {
        this.connector.getElement().setProperty("noAuto", !autoUpload);
    }

    public boolean isAutoUpload() {
        return !this.connector.getElement().getProperty("noAuto", false);
    }

    public void setUploadFormat(UploadFormat format) {
        Objects.requireNonNull(format, "Upload format cannot be null");
        this.connector.getElement().setProperty("uploadFormat", format.name().toLowerCase(Locale.ENGLISH));
    }

    public UploadFormat getUploadFormat() {
        String value = this.connector.getElement().getProperty("uploadFormat", "raw");
        return UploadFormat.valueOf(value.toUpperCase(Locale.ENGLISH));
    }

    public void setEnabled(boolean enabled) {
        this.connector.getElement().setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.connector.getElement().isEnabled();
    }

    public boolean isUploading() {
        return this.activeUploads.get() > 0;
    }

    public void clearFileList() {
        this.connector.getElement().callJsFunction("clearFileList", new Object[0]);
    }

    private void startUpload() {
        int maxFiles = this.getMaxFiles();
        int current = this.activeUploads.get();
        if (maxFiles != 0 && maxFiles <= current) {
            throw new IllegalStateException("Maximum supported amount of uploads already started");
        }
        this.activeUploads.incrementAndGet();
    }

    private void endUpload() {
        this.activeUploads.decrementAndGet();
    }

    public Registration addFileRemovedListener(ComponentEventListener<FileRemovedEvent> listener) {
        return ComponentUtil.addListener((Component)this.owner, FileRemovedEvent.class, listener);
    }

    public Registration addFileRejectedListener(ComponentEventListener<FileRejectedEvent> listener) {
        return ComponentUtil.addListener((Component)this.owner, FileRejectedEvent.class, listener);
    }

    public Registration addAllFinishedListener(ComponentEventListener<AllFinishedEvent> listener) {
        return ComponentUtil.addListener((Component)this.owner, AllFinishedEvent.class, listener);
    }

    boolean isHandlerExplicitlyConfigured() {
        return this.handlerExplicitlyConfigured.get();
    }

    @Tag(value="vaadin-upload-manager-connector")
    @JsModule(value="./vaadin-upload-manager-connector.ts")
    @NpmPackage(value="@vaadin/upload", version="25.1.0-alpha8")
    static class Connector
    extends Component {
        Connector() {
        }

        protected void onAttach(AttachEvent attachEvent) {
            super.onAttach(attachEvent);
            this.checkFeatureFlag(attachEvent.getUI());
        }

        private void checkFeatureFlag(UI ui) {
            boolean enabled;
            FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext());
            boolean bl = enabled = featureFlags.isEnabled(UploadManager.FEATURE_FLAG_ID) || featureFlags.isEnabled("aiComponents");
            if (!enabled) {
                throw new ModularUploadExperimentalFeatureException();
            }
        }
    }

    private static final class FailFastUploadHandler
    implements UploadHandler {
        private FailFastUploadHandler() {
        }

        public void handleUploadRequest(UploadEvent event) {
            throw new IllegalStateException("Upload cannot be performed without an upload handler set. Please first set the upload handler with setUploadHandler()");
        }
    }

    public static class FileRemovedEvent
    extends ComponentEvent<Component> {
        private final String fileName;

        public FileRemovedEvent(Component source, boolean fromClient, String fileName) {
            super(source, fromClient);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public static class FileRejectedEvent
    extends ComponentEvent<Component> {
        private final String fileName;
        private final FileRejectionReason reason;

        public FileRejectedEvent(Component source, boolean fromClient, FileRejectionReason reason, String fileName) {
            super(source, fromClient);
            this.reason = reason;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public FileRejectionReason getReason() {
            return this.reason;
        }
    }

    public static class AllFinishedEvent
    extends ComponentEvent<Component> {
        public AllFinishedEvent(Component source) {
            super(source, false);
        }
    }

    public static enum FileRejectionReason {
        TOO_MANY_FILES("tooManyFiles"),
        FILE_TOO_LARGE("fileIsTooBig"),
        INCORRECT_FILE_TYPE("incorrectFileType"),
        UNKNOWN(null);

        private final String clientCode;

        private FileRejectionReason(String clientCode) {
            this.clientCode = clientCode;
        }

        public static FileRejectionReason fromClientCode(String clientCode) {
            for (FileRejectionReason reason : FileRejectionReason.values()) {
                if (reason.clientCode == null || !reason.clientCode.equals(clientCode)) continue;
                return reason;
            }
            return UNKNOWN;
        }
    }
}

