/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.streams.UploadCompleteEvent;
import com.vaadin.flow.internal.streams.UploadStartEvent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class UploadManager
implements Serializable {
    private final Connector connector = new Connector();
    private final Component owner;
    private final AtomicInteger activeUploads = new AtomicInteger(0);

    public UploadManager(Component owner) {
        this(owner, null);
    }

    public UploadManager(Component owner, UploadHandler handler) {
        Objects.requireNonNull(owner, "Owner component cannot be null");
        this.owner = owner;
        owner.getElement().appendVirtualChild(new Element[]{this.connector.getElement()});
        this.setUploadHandler((UploadHandler)(handler != null ? handler : new FailFastUploadHandler()));
        String eventDetailFileName = "event.detail.fileName";
        String eventDetailErrorMessage = "event.detail.errorMessage";
        this.connector.getElement().addEventListener("file-remove", (DomEventListener & Serializable)event -> {
            String fileName = event.getEventData().get("event.detail.fileName").asString();
            ComponentUtil.fireEvent((Component)owner, (ComponentEvent)new FileRemovedEvent(owner, true, fileName));
        }).addEventData("event.detail.fileName");
        this.connector.getElement().addEventListener("file-reject", (DomEventListener & Serializable)event -> {
            String fileName = event.getEventData().get("event.detail.fileName").asString();
            String errorMessage = event.getEventData().get("event.detail.errorMessage").asString();
            ComponentUtil.fireEvent((Component)owner, (ComponentEvent)new FileRejectedEvent(owner, true, errorMessage, fileName));
        }).addEventData("event.detail.fileName").addEventData("event.detail.errorMessage");
        ComponentUtil.addListener((Component)this.connector, UploadStartEvent.class, (ComponentEventListener & Serializable)event -> this.startUpload());
        ComponentUtil.addListener((Component)this.connector, UploadCompleteEvent.class, (ComponentEventListener & Serializable)event -> this.endUpload());
    }

    Connector getConnector() {
        return this.connector;
    }

    public void setUploadHandler(UploadHandler handler) {
        this.setUploadHandler(handler, "upload");
    }

    public void setUploadHandler(UploadHandler handler, final String targetName) {
        Objects.requireNonNull(handler, "UploadHandler cannot be null");
        Objects.requireNonNull(targetName, "The target name cannot be null");
        if (targetName.isBlank()) {
            throw new IllegalArgumentException("The target name cannot be blank");
        }
        StreamResourceRegistry.ElementStreamResource elementStreamResource = new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)handler, this.connector.getElement()){

            public String getName() {
                return targetName;
            }
        };
        this.connector.getElement().setAttribute("target", (AbstractStreamResource)elementStreamResource);
    }

    public void setMaxFiles(int maxFiles) {
        this.connector.getElement().setProperty("maxFiles", maxFiles == 0 ? Double.POSITIVE_INFINITY : (double)maxFiles);
    }

    public int getMaxFiles() {
        double value = this.connector.getElement().getProperty("maxFiles", 0.0);
        return Double.isInfinite(value) ? 0 : (int)value;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.connector.getElement().setProperty("maxFileSize", maxFileSize == 0L ? Double.POSITIVE_INFINITY : (double)maxFileSize);
    }

    public long getMaxFileSize() {
        double value = this.connector.getElement().getProperty("maxFileSize", 0.0);
        return Double.isInfinite(value) ? 0L : (long)value;
    }

    public void setAcceptedFileTypes(String ... acceptedFileTypes) {
        String accept = "";
        if (acceptedFileTypes != null) {
            for (String fileType : acceptedFileTypes) {
                if (fileType != null && !fileType.isBlank()) continue;
                throw new IllegalArgumentException("Accepted file types cannot contain null or blank values");
            }
            accept = String.join((CharSequence)",", acceptedFileTypes);
        }
        this.connector.getElement().setProperty("accept", accept);
    }

    public List<String> getAcceptedFileTypes() {
        String accept = this.connector.getElement().getProperty("accept", "");
        if (accept.isEmpty()) {
            return List.of();
        }
        return List.of(accept.split(","));
    }

    public void setAutoUpload(boolean autoUpload) {
        this.connector.getElement().setProperty("noAuto", !autoUpload);
    }

    public boolean isAutoUpload() {
        return !this.connector.getElement().getProperty("noAuto", false);
    }

    public void setEnabled(boolean enabled) {
        this.connector.getElement().setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.connector.getElement().isEnabled();
    }

    public boolean isUploading() {
        return this.activeUploads.get() > 0;
    }

    public void clearFileList() {
        this.connector.getElement().callJsFunction("clearFileList", new Object[0]);
    }

    private void startUpload() {
        int maxFiles = this.getMaxFiles();
        int current = this.activeUploads.get();
        if (maxFiles != 0 && maxFiles <= current) {
            throw new IllegalStateException("Maximum supported amount of uploads already started");
        }
        this.activeUploads.incrementAndGet();
    }

    private void endUpload() {
        int remaining = this.activeUploads.decrementAndGet();
        if (remaining == 0) {
            this.fireAllFinished();
        }
    }

    private void fireAllFinished() {
        this.owner.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> ComponentUtil.fireEvent((Component)this.owner, (ComponentEvent)new AllFinishedEvent(this.owner))));
    }

    public Registration addFileRemovedListener(ComponentEventListener<FileRemovedEvent> listener) {
        return ComponentUtil.addListener((Component)this.owner, FileRemovedEvent.class, listener);
    }

    public Registration addFileRejectedListener(ComponentEventListener<FileRejectedEvent> listener) {
        return ComponentUtil.addListener((Component)this.owner, FileRejectedEvent.class, listener);
    }

    public Registration addAllFinishedListener(ComponentEventListener<AllFinishedEvent> listener) {
        return ComponentUtil.addListener((Component)this.owner, AllFinishedEvent.class, listener);
    }

    @Tag(value="vaadin-upload-manager-connector")
    @JsModule(value="./vaadin-upload-manager-connector.ts")
    @NpmPackage(value="@vaadin/upload", version="25.1.0-alpha6")
    static class Connector
    extends Component {
        Connector() {
        }
    }

    private static final class FailFastUploadHandler
    implements UploadHandler {
        private FailFastUploadHandler() {
        }

        public void handleUploadRequest(UploadEvent event) {
            throw new IllegalStateException("Upload cannot be performed without an upload handler set. Please first set the upload handler with setUploadHandler()");
        }
    }

    public static class FileRemovedEvent
    extends ComponentEvent<Component> {
        private final String fileName;

        public FileRemovedEvent(Component source, boolean fromClient, String fileName) {
            super(source, fromClient);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public static class FileRejectedEvent
    extends ComponentEvent<Component> {
        private final String fileName;
        private final String errorMessage;

        public FileRejectedEvent(Component source, boolean fromClient, String errorMessage, String fileName) {
            super(source, fromClient);
            this.errorMessage = errorMessage;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class AllFinishedEvent
    extends ComponentEvent<Component> {
        public AllFinishedEvent(Component source) {
            super(source, false);
        }
    }
}

