/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.upload.HasUploadManager;
import com.vaadin.flow.component.upload.UploadFileListI18N;
import com.vaadin.flow.component.upload.UploadFileListVariant;
import com.vaadin.flow.component.upload.UploadManager;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import java.io.Serializable;
import java.util.Objects;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-upload-file-list")
@NpmPackage(value="@vaadin/upload", version="25.1.0-alpha5")
@JsModule(value="@vaadin/upload/src/vaadin-upload-file-list.js")
public class UploadFileList
extends Component
implements HasUploadManager,
HasThemeVariant<UploadFileListVariant> {
    private UploadFileListI18N i18n;

    public UploadFileList() {
    }

    public UploadFileList(UploadManager manager) {
        this.setUploadManager(Objects.requireNonNull(manager, "manager cannot be null, use the default constructor instead"));
    }

    public void setI18n(UploadFileListI18N i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                this.setI18nWithJS();
            }
        });
    }

    public UploadFileListI18N getI18n() {
        return this.i18n;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
    }

    private void setI18nWithJS() {
        ObjectNode i18nJson = JacksonUtils.beanToJson((Object)this.i18n);
        this.getElement().executeJs("const file = Object.assign({}, this.i18n.file, $0.file);const error = Object.assign({}, this.i18n.error, $0.error);const uploadingStatus = Object.assign({}, this.i18n.uploading.status, $0.uploading && $0.uploading.status);const uploadingRemainingTime = Object.assign({}, this.i18n.uploading.remainingTime, $0.uploading && $0.uploading.remainingTime);const uploadingError = Object.assign({}, this.i18n.uploading.error, $0.uploading && $0.uploading.error);const uploading = {status: uploadingStatus,  remainingTime: uploadingRemainingTime,  error: uploadingError};const units = $0.units || this.i18n.units;this.i18n = Object.assign({}, this.i18n, $0, {  file: file, error: error, uploading: uploading, units: units});", new Object[]{i18nJson});
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }
}

