/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UploadFileListI18N
implements Serializable {
    private File file;
    private Error error;
    private Uploading uploading;
    private Units units;

    public File getFile() {
        return this.file;
    }

    public UploadFileListI18N setFile(File file) {
        this.file = file;
        return this;
    }

    public Error getError() {
        return this.error;
    }

    public UploadFileListI18N setError(Error error) {
        this.error = error;
        return this;
    }

    public Uploading getUploading() {
        return this.uploading;
    }

    public UploadFileListI18N setUploading(Uploading uploading) {
        this.uploading = uploading;
        return this;
    }

    public Units getUnits() {
        return this.units;
    }

    public UploadFileListI18N setUnits(Units units) {
        this.units = units;
        return this;
    }

    public UploadFileListI18N setUnits(List<String> units) {
        this.units = new Units(units);
        return this;
    }

    public UploadFileListI18N setUnits(List<String> units, int sizeBase) {
        this.units = new Units(units, sizeBase);
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class File
    implements Serializable {
        private String retry;
        private String start;
        private String remove;

        public String getRetry() {
            return this.retry;
        }

        public File setRetry(String retry) {
            this.retry = retry;
            return this;
        }

        public String getStart() {
            return this.start;
        }

        public File setStart(String start) {
            this.start = start;
            return this;
        }

        public String getRemove() {
            return this.remove;
        }

        public File setRemove(String remove) {
            this.remove = remove;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Error
    implements Serializable {
        private String tooManyFiles;
        private String fileIsTooBig;
        private String incorrectFileType;

        public String getTooManyFiles() {
            return this.tooManyFiles;
        }

        public Error setTooManyFiles(String tooManyFiles) {
            this.tooManyFiles = tooManyFiles;
            return this;
        }

        public String getFileIsTooBig() {
            return this.fileIsTooBig;
        }

        public Error setFileIsTooBig(String fileIsTooBig) {
            this.fileIsTooBig = fileIsTooBig;
            return this;
        }

        public String getIncorrectFileType() {
            return this.incorrectFileType;
        }

        public Error setIncorrectFileType(String incorrectFileType) {
            this.incorrectFileType = incorrectFileType;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Uploading
    implements Serializable {
        private Status status;
        private RemainingTime remainingTime;
        private UploadError error;

        public Status getStatus() {
            return this.status;
        }

        public Uploading setStatus(Status status) {
            this.status = status;
            return this;
        }

        public RemainingTime getRemainingTime() {
            return this.remainingTime;
        }

        public Uploading setRemainingTime(RemainingTime remainingTime) {
            this.remainingTime = remainingTime;
            return this;
        }

        public UploadError getError() {
            return this.error;
        }

        public Uploading setError(UploadError error) {
            this.error = error;
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class Status
        implements Serializable {
            private String connecting;
            private String stalled;
            private String processing;
            private String held;

            public String getConnecting() {
                return this.connecting;
            }

            public Status setConnecting(String connecting) {
                this.connecting = connecting;
                return this;
            }

            public String getStalled() {
                return this.stalled;
            }

            public Status setStalled(String stalled) {
                this.stalled = stalled;
                return this;
            }

            public String getProcessing() {
                return this.processing;
            }

            public Status setProcessing(String processing) {
                this.processing = processing;
                return this;
            }

            public String getHeld() {
                return this.held;
            }

            public Status setHeld(String held) {
                this.held = held;
                return this;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class RemainingTime
        implements Serializable {
            private String prefix;
            private String unknown;

            public String getPrefix() {
                return this.prefix;
            }

            public RemainingTime setPrefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public String getUnknown() {
                return this.unknown;
            }

            public RemainingTime setUnknown(String unknown) {
                this.unknown = unknown;
                return this;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class UploadError
        implements Serializable {
            private String serverUnavailable;
            private String unexpectedServerError;
            private String forbidden;
            private String fileTooLarge;

            public String getServerUnavailable() {
                return this.serverUnavailable;
            }

            public UploadError setServerUnavailable(String serverUnavailable) {
                this.serverUnavailable = serverUnavailable;
                return this;
            }

            public String getUnexpectedServerError() {
                return this.unexpectedServerError;
            }

            public UploadError setUnexpectedServerError(String unexpectedServerError) {
                this.unexpectedServerError = unexpectedServerError;
                return this;
            }

            public String getForbidden() {
                return this.forbidden;
            }

            public UploadError setForbidden(String forbidden) {
                this.forbidden = forbidden;
                return this;
            }

            public String getFileTooLarge() {
                return this.fileTooLarge;
            }

            public UploadError setFileTooLarge(String fileTooLarge) {
                this.fileTooLarge = fileTooLarge;
                return this;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Units
    implements Serializable {
        private List<String> size = Arrays.asList("B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB");
        private Integer sizeBase;

        public Units() {
        }

        public Units(List<String> size) {
            this.size = size;
        }

        public Units(List<String> size, Integer sizeBase) {
            this.size = size;
            this.sizeBase = sizeBase;
        }

        public List<String> getSize() {
            return this.size;
        }

        public Units setSize(List<String> size) {
            this.size = size;
            return this;
        }

        public Integer getSizeBase() {
            return this.sizeBase;
        }

        public Units setSizeBase(Integer sizeBase) {
            this.sizeBase = sizeBase;
            return this;
        }
    }
}

