/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker.testbench;

import com.vaadin.testbench.HasClearButton;
import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.HasStringValueProperty;
import com.vaadin.testbench.HasValidation;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.Objects;
import org.openqa.selenium.Keys;

@Element(value="vaadin-time-picker")
public class TimePickerElement
extends TestBenchElement
implements HasStringValueProperty,
HasSelectByText,
HasHelper,
HasClearButton,
HasValidation {
    public TestBenchElement getTimePickerInputElement() {
        return this.$("input").first();
    }

    public String getText() {
        return this.getPropertyString(new String[]{"textContent"});
    }

    public TestBenchElement getItem(int index) {
        return this.$("vaadin-time-picker-item").all().stream().filter(item -> index == item.getPropertyInteger(new String[]{"index"})).findFirst().get();
    }

    public TestBenchElement getLastItem() {
        return (TestBenchElement)this.$("vaadin-time-picker-item").all().stream().max((a, b) -> a.getPropertyInteger(new String[]{"index"}) - b.getPropertyInteger(new String[]{"index"})).get();
    }

    public String getItemText(int index) {
        return this.getItem(index).getText();
    }

    public String getLastItemText() {
        return this.getLastItem().getText();
    }

    public String getTimePickerInputValue() {
        return this.getTimePickerInputElement().getPropertyString(new String[]{"value"});
    }

    public void openDropDown() {
        this.callFunction("open", new Object[0]);
    }

    public void closeDropDown() {
        this.executeScript("const cb = arguments[0]; window.requestAnimationFrame(function(){ cb.close(); });", new Object[]{this});
    }

    public void scrollToItem(int index) {
        this.executeScript("arguments[0]._scroller.scrollIntoView(arguments[1])", new Object[]{this, index});
    }

    public void selectItemByIndex(int index) {
        this.openDropDown();
        this.scrollToItem(index);
        TestBenchElement item = this.getItem(index);
        item.click();
    }

    public void selectByText(String timeInput) {
        Objects.requireNonNull(timeInput, "null input not accepted");
        this.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, Keys.HOME}), Keys.BACK_SPACE});
        this.sendKeys(new CharSequence[]{timeInput, Keys.ENTER});
    }

    public String getSelectedText() {
        return this.getTimePickerInputElement().getPropertyString(new String[]{"value"});
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.getTimePickerInputElement().sendKeys(keysToSend);
    }
}

