/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import java.time.Duration;

public class StepsUtil {
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    private static final long MILLISECONDS_IN_AN_HOUR = 3600000L;
    public static final Duration DEFAULT_WEB_COMPONENT_STEP = Duration.ofHours(1L);

    public static double convertDurationToStepsValue(Duration duration) {
        long stepAsMilliseconds = duration.getSeconds() * 1000L + (long)((double)duration.getNano() / 1000000.0);
        if (duration.isNegative() || stepAsMilliseconds == 0L) {
            throw new IllegalArgumentException("Step cannot be negative and must be larger than 0 milliseconds");
        }
        if (86400000L % stepAsMilliseconds != 0L && 3600000L % stepAsMilliseconds != 0L) {
            throw new IllegalArgumentException("Given step " + String.valueOf(duration) + " does not divide evenly a day or an hour.");
        }
        return (double)duration.getSeconds() + (double)duration.getNano() / 1.0E9;
    }

    public static Duration convertStepsValueToDuration(double stepsValue) {
        return Duration.ofNanos((long)(stepsValue * 1.0E9));
    }
}

