/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.flow.component.textfield.AbstractNumberFieldI18n;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.function.SerializableFunction;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

@Tag(value="vaadin-number-field")
@NpmPackage(value="@vaadin/number-field", version="25.1.0-alpha3")
@JsModule(value="@vaadin/number-field/src/vaadin-number-field.js")
public class NumberField
extends AbstractNumberField<NumberField, Double>
implements HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant> {
    public NumberField() {
        this(new Formatter());
    }

    public NumberField(String label) {
        this();
        this.setLabel(label);
    }

    public NumberField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public NumberField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, Double initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private NumberField(Formatter formatter) {
        super(formatter::parse, formatter, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    @Override
    public void setMin(double min) {
        super.setMin(min);
    }

    public double getMin() {
        return this.getMinDouble();
    }

    @Override
    public void setMax(double max) {
        super.setMax(max);
    }

    public double getMax() {
        return this.getMaxDouble();
    }

    @Override
    public void setStep(double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep(step);
    }

    public double getStep() {
        return this.getStepDouble();
    }

    @Override
    public NumberFieldI18n getI18n() {
        return (NumberFieldI18n)super.getI18n();
    }

    public void setI18n(NumberFieldI18n i18n) {
        super.setI18n(i18n);
    }

    private static class Formatter
    implements SerializableFunction<Double, String> {
        private final DecimalFormat decimalFormat = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

        private Formatter() {
            this.decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        }

        public String apply(Double valueFromModel) {
            return valueFromModel == null ? "" : this.decimalFormat.format(valueFromModel);
        }

        private Double parse(String valueFromClient) {
            try {
                return valueFromClient == null || valueFromClient.isEmpty() ? null : Double.valueOf(this.decimalFormat.parse(valueFromClient).doubleValue());
            }
            catch (ParseException e) {
                throw new NumberFormatException(valueFromClient);
            }
        }
    }

    public static class NumberFieldI18n
    implements AbstractNumberFieldI18n {
        private String requiredErrorMessage;
        private String badInputErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;
        private String stepErrorMessage;

        @Override
        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public NumberFieldI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public NumberFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public NumberFieldI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public NumberFieldI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }

        @Override
        public String getStepErrorMessage() {
            return this.stepErrorMessage;
        }

        public NumberFieldI18n setStepErrorMessage(String errorMessage) {
            this.stepErrorMessage = errorMessage;
            return this;
        }
    }
}

