/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.SignalPropertySupport;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.textfield.AbstractNumberFieldI18n;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractNumberField<C extends AbstractNumberField<C, T>, T extends Number>
extends TextFieldBase<C, T> {
    private AbstractNumberFieldI18n i18n;
    private double min;
    private double max;
    private double step;
    private boolean stepSetByUser;
    private boolean minSetByUser;
    private DomListenerRegistration inputListenerRegistration;
    private String unparsableValue;
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<T>> validationStatusChangeListeners = new CopyOnWriteArrayList();
    private Validator<T> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (this.unparsableValue != null) {
            return ValidationResult.error((String)this.getI18nErrorMessage(AbstractNumberFieldI18n::getBadInputErrorMessage));
        }
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(AbstractNumberFieldI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)this.getEmptyValue())).isError()) {
            return requiredResult;
        }
        Double doubleValue = value != null ? Double.valueOf(value.doubleValue()) : null;
        ValidationResult maxResult = ValidationUtil.validateMaxConstraint((String)this.getI18nErrorMessage(AbstractNumberFieldI18n::getMaxErrorMessage), (Comparable)doubleValue, (Comparable)Double.valueOf(this.max));
        if (maxResult.isError()) {
            return maxResult;
        }
        ValidationResult minResult = ValidationUtil.validateMinConstraint((String)this.getI18nErrorMessage(AbstractNumberFieldI18n::getMinErrorMessage), (Comparable)doubleValue, (Comparable)Double.valueOf(this.min));
        if (minResult.isError()) {
            return minResult;
        }
        if (!this.isValidByStep(value)) {
            return ValidationResult.error((String)this.getI18nErrorMessage(AbstractNumberFieldI18n::getStepErrorMessage));
        }
        return ValidationResult.ok();
    };
    private ValidationController<AbstractNumberField<C, T>, T> validationController = new ValidationController((Component)this);
    private final SignalPropertySupport<Double> minSupport = SignalPropertySupport.create((Component)this, (SerializableConsumer & Serializable)value -> {
        this.min = value;
    });
    private final SignalPropertySupport<Double> maxSupport = SignalPropertySupport.create((Component)this, (SerializableConsumer & Serializable)value -> {
        this.max = value;
    });

    public AbstractNumberField(SerializableFunction<String, T> parser, SerializableFunction<T, String> formatter, double absoluteMin, double absoluteMax) {
        super(null, null, String.class, parser, formatter, true);
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.min = absoluteMin;
        this.max = absoluteMax;
        this.step = 1.0;
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)e -> this.setModelValue((T)this.getEmptyValue(), true)).synchronizeProperty("_inputElementValue");
    }

    @Override
    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        if (this.inputListenerRegistration != null) {
            this.inputListenerRegistration.remove();
            this.inputListenerRegistration = null;
        }
        if (ValueChangeMode.EAGER.equals((Object)valueChangeMode) || ValueChangeMode.LAZY.equals((Object)valueChangeMode) || ValueChangeMode.TIMEOUT.equals((Object)valueChangeMode)) {
            this.inputListenerRegistration = this.getElement().addEventListener("input", (DomEventListener & Serializable)event -> this.setModelValue((T)this.getValue(), true));
        }
        super.setValueChangeMode(valueChangeMode);
        this.getSynchronizationRegistration().synchronizeProperty("_inputElementValue");
    }

    @Override
    void applyChangeTimeout() {
        super.applyChangeTimeout();
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.inputListenerRegistration);
    }

    public void setStepButtonsVisible(boolean stepButtonsVisible) {
        this.getElement().setProperty("stepButtonsVisible", stepButtonsVisible);
    }

    public boolean isStepButtonsVisible() {
        return this.getElement().getProperty("stepButtonsVisible", false);
    }

    public T getEmptyValue() {
        return null;
    }

    public void setValue(T value) {
        Object oldValue = this.getValue();
        if (oldValue == null && value == null && this.unparsableValue != null) {
            this.setModelValue((T)this.getEmptyValue(), false);
            return;
        }
        super.setValue(value);
    }

    protected void setModelValue(T newModelValue, boolean fromClient) {
        boolean isModelValueRemainedEmpty;
        Object oldModelValue = this.getValue();
        String oldUnparsableValue = this.unparsableValue;
        this.unparsableValue = fromClient && newModelValue == null && !this.getInputElementValue().isEmpty() ? this.getInputElementValue() : null;
        boolean bl = isModelValueRemainedEmpty = newModelValue == null && oldModelValue == null;
        if (fromClient && isModelValueRemainedEmpty) {
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        if (!fromClient && isModelValueRemainedEmpty && oldUnparsableValue != null) {
            this.setInputElementValue("");
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        super.setModelValue(newModelValue, fromClient);
    }

    public T getValue() {
        return (T)((Number)super.getValue());
    }

    protected void setMin(double min) {
        this.getElement().setProperty("min", min);
        this.min = min;
        this.minSetByUser = true;
    }

    protected double getMinDouble() {
        return this.min;
    }

    protected void setMax(double max) {
        this.getElement().setProperty("max", max);
        this.max = max;
    }

    protected double getMaxDouble() {
        return this.max;
    }

    protected final void bindMinInternal(Signal<Double> signal) {
        this.getElement().bindProperty("min", signal, null);
        this.minSupport.bind(signal);
    }

    protected final void bindMaxInternal(Signal<Double> signal) {
        this.getElement().bindProperty("max", signal, null);
        this.maxSupport.bind(signal);
    }

    protected void setStep(double step) {
        this.getElement().setProperty("step", step);
        this.step = step;
        this.stepSetByUser = true;
    }

    protected double getStepDouble() {
        return this.step;
    }

    private String getInputElementValue() {
        return this.getElement().getProperty("_inputElementValue", "");
    }

    private void setInputElementValue(String value) {
        this.getElement().setProperty("_inputElementValue", value);
    }

    public Validator<T> getDefaultValidator() {
        return this.defaultValidator;
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<T> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    private void fireValidationStatusChangeEvent() {
        ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
        this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<T>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate(this.getValue());
    }

    private boolean isValidByStep(T value) {
        if (!this.stepSetByUser || value == null || this.step == 0.0) {
            return true;
        }
        double stepBasis = this.minSetByUser && !Double.isInfinite(this.getMinDouble()) ? this.getMinDouble() : 0.0;
        return new BigDecimal(String.valueOf(value)).subtract(BigDecimal.valueOf(stepBasis)).remainder(BigDecimal.valueOf(this.step)).compareTo(BigDecimal.ZERO) == 0;
    }

    protected AbstractNumberFieldI18n getI18n() {
        return this.i18n;
    }

    protected void setI18n(AbstractNumberFieldI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<AbstractNumberFieldI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }
}

