/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Tag(value="vaadin-password-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.10"), @NpmPackage(value="@vaadin/password-field", version="24.9.10")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/password-field/src/vaadin-password-field.js")})
public class PasswordField
extends TextFieldBase<PasswordField, String>
implements HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant> {
    private PasswordFieldI18n i18n;
    private Validator<String> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(PasswordFieldI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)this.getEmptyValue())).isError()) {
            return requiredResult;
        }
        ValidationResult maxLengthResult = ValidationUtil.validateMaxLengthConstraint((String)this.getI18nErrorMessage(PasswordFieldI18n::getMaxLengthErrorMessage), (String)value, this.hasMaxLength() ? Integer.valueOf(this.getMaxLength()) : null);
        if (maxLengthResult.isError()) {
            return maxLengthResult;
        }
        ValidationResult minLengthResult = ValidationUtil.validateMinLengthConstraint((String)this.getI18nErrorMessage(PasswordFieldI18n::getMinLengthErrorMessage), (String)value, (Integer)this.getMinLength());
        if (minLengthResult.isError()) {
            return minLengthResult;
        }
        ValidationResult patternResult = ValidationUtil.validatePatternConstraint((String)this.getI18nErrorMessage(PasswordFieldI18n::getPatternErrorMessage), (String)value, (String)this.getPattern());
        if (patternResult.isError()) {
            return patternResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<PasswordField, String> validationController = new ValidationController((Component)this);

    public PasswordField() {
        this(true);
    }

    private PasswordField(boolean isInitialValueOptional) {
        super("", "", false, isInitialValueOptional);
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public PasswordField(String label) {
        this();
        this.setLabel(label);
    }

    public PasswordField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public PasswordField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<PasswordField, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public PasswordField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<PasswordField, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public PasswordField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<PasswordField, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public void setMaxLength(int maxLength) {
        this.getElement().setProperty("maxlength", (double)maxLength);
    }

    public int getMaxLength() {
        return (int)this.getElement().getProperty("maxlength", 0.0);
    }

    private boolean hasMaxLength() {
        return this.getElement().getProperty("maxlength") != null;
    }

    public void setMinLength(int minLength) {
        this.getElement().setProperty("minlength", (double)minLength);
    }

    public int getMinLength() {
        return (int)this.getElement().getProperty("minlength", 0.0);
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    public boolean isRevealButtonVisible() {
        return !this.getElement().getProperty("revealButtonHidden", false);
    }

    public void setRevealButtonVisible(boolean revealButtonVisible) {
        this.getElement().setProperty("revealButtonHidden", !revealButtonVisible);
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public Validator<String> getDefaultValidator() {
        return this.defaultValidator;
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)this.getValue());
    }

    public PasswordFieldI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(PasswordFieldI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<PasswordFieldI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class PasswordFieldI18n
    implements Serializable {
        private String requiredErrorMessage;
        private String minLengthErrorMessage;
        private String maxLengthErrorMessage;
        private String patternErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public PasswordFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinLengthErrorMessage() {
            return this.minLengthErrorMessage;
        }

        public PasswordFieldI18n setMinLengthErrorMessage(String errorMessage) {
            this.minLengthErrorMessage = errorMessage;
            return this;
        }

        public String getMaxLengthErrorMessage() {
            return this.maxLengthErrorMessage;
        }

        public PasswordFieldI18n setMaxLengthErrorMessage(String errorMessage) {
            this.maxLengthErrorMessage = errorMessage;
            return this;
        }

        public String getPatternErrorMessage() {
            return this.patternErrorMessage;
        }

        public PasswordFieldI18n setPatternErrorMessage(String errorMessage) {
            this.patternErrorMessage = errorMessage;
            return this;
        }
    }
}

