/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;

@Tag(value="vaadin-big-decimal-field")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.14")
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="./vaadin-big-decimal-field.js")})
@Uses(value=TextField.class)
public class BigDecimalField
extends TextFieldBase<BigDecimalField, BigDecimal>
implements HasThemeVariant<TextFieldVariant> {
    private BigDecimalFieldI18n i18n;
    private Locale locale;
    private static final SerializableBiFunction<BigDecimalField, String, BigDecimal> PARSER = (SerializableBiFunction & Serializable)(field, valueFromClient) -> {
        if (valueFromClient == null || valueFromClient.isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(valueFromClient.replace(field.getDecimalSeparator(), '.'));
        }
        catch (NumberFormatException e) {
            return null;
        }
    };
    private static final SerializableBiFunction<BigDecimalField, BigDecimal, String> FORMATTER = (SerializableBiFunction & Serializable)(field, valueFromModel) -> valueFromModel == null ? "" : valueFromModel.toPlainString().replace('.', field.getDecimalSeparator());
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<BigDecimal>> validationStatusChangeListeners = new CopyOnWriteArrayList();
    private Validator<BigDecimal> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean hasBadInput;
        boolean fromComponent = context == null;
        boolean bl = hasBadInput = this.valueEquals(value, this.getEmptyValue()) && !this.getInputElementValue().isEmpty();
        if (hasBadInput) {
            return ValidationResult.error((String)this.getI18nErrorMessage(BigDecimalFieldI18n::getBadInputErrorMessage));
        }
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(BigDecimalFieldI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)this.getEmptyValue())).isError()) {
            return requiredResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<BigDecimalField, BigDecimal> validationController = new ValidationController((Component)this);

    public BigDecimalField() {
        super(null, null, String.class, PARSER, FORMATTER, true);
        this.setLocale(Optional.ofNullable(UI.getCurrent()).map(UI::getLocale).orElse(Locale.ROOT));
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public BigDecimalField(String label) {
        this();
        this.setLabel(label);
    }

    public BigDecimalField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public BigDecimalField(String label, BigDecimal initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public BigDecimalField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public BigDecimalField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public BigDecimalField(String label, BigDecimal initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<BigDecimalField, BigDecimal>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public BigDecimal getEmptyValue() {
        return null;
    }

    public void setValue(BigDecimal value) {
        BigDecimal oldValue = this.getValue();
        if (oldValue == null && value == null && !this.getInputElementValue().isEmpty()) {
            this.setModelValue(this.getEmptyValue(), false);
            return;
        }
        super.setValue((Object)value);
    }

    protected void setModelValue(BigDecimal newModelValue, boolean fromClient) {
        boolean isModelValueRemainedEmpty;
        BigDecimal oldModelValue = this.getValue();
        boolean bl = isModelValueRemainedEmpty = oldModelValue == null && newModelValue == null;
        if (fromClient && isModelValueRemainedEmpty) {
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        if (!fromClient && isModelValueRemainedEmpty && !this.getInputElementValue().isEmpty()) {
            this.setInputElementValue("");
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        super.setModelValue((Object)newModelValue, fromClient);
    }

    public BigDecimal getValue() {
        return (BigDecimal)super.getValue();
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)this.getValue());
    }

    public Validator<BigDecimal> getDefaultValidator() {
        return this.defaultValidator;
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<BigDecimal> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    private void fireValidationStatusChangeEvent() {
        ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
        this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<BigDecimal>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
    }

    private String getInputElementValue() {
        return this.getElement().getProperty("value", "");
    }

    private void setInputElementValue(String value) {
        this.getElement().setProperty("value", value);
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale to set can't be null.");
        this.locale = locale;
        this.setDecimalSeparator(new DecimalFormatSymbols(locale).getDecimalSeparator());
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setDecimalSeparator(char decimalSeparator) {
        this.getElement().setProperty("_decimalSeparator", "" + decimalSeparator);
    }

    private char getDecimalSeparator() {
        String prop = this.getElement().getProperty("_decimalSeparator");
        return prop == null || prop.isEmpty() ? (char)'.' : this.getElement().getProperty("_decimalSeparator").charAt(0);
    }

    public BigDecimalFieldI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(BigDecimalFieldI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<BigDecimalFieldI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class BigDecimalFieldI18n
    implements Serializable {
        private String requiredErrorMessage;
        private String badInputErrorMessage;

        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public BigDecimalFieldI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public BigDecimalFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }
    }
}

