/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Tag(value="vaadin-email-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.10.0-alpha2"), @NpmPackage(value="@vaadin/email-field", version="24.10.0-alpha2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/email-field/src/vaadin-email-field.js")})
public class EmailField
extends TextFieldBase<EmailField, String>
implements HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant> {
    private EmailFieldI18n i18n;
    private Validator<String> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(EmailFieldI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)this.getEmptyValue())).isError()) {
            return requiredResult;
        }
        ValidationResult maxLengthResult = ValidationUtil.validateMaxLengthConstraint((String)this.getI18nErrorMessage(EmailFieldI18n::getMaxLengthErrorMessage), (String)value, this.hasMaxLength() ? Integer.valueOf(this.getMaxLength()) : null);
        if (maxLengthResult.isError()) {
            return maxLengthResult;
        }
        ValidationResult minLengthResult = ValidationUtil.validateMinLengthConstraint((String)this.getI18nErrorMessage(EmailFieldI18n::getMinLengthErrorMessage), (String)value, (Integer)this.getMinLength());
        if (minLengthResult.isError()) {
            return minLengthResult;
        }
        ValidationResult patternResult = ValidationUtil.validatePatternConstraint((String)this.getI18nErrorMessage(EmailFieldI18n::getPatternErrorMessage), (String)value, (String)(this.hasPattern() ? this.getPattern() : "^([a-zA-Z0-9_\\.\\-+])+@([a-zA-Z0-9-]+\\.)+[a-zA-Z0-9-]{2,}$"));
        if (patternResult.isError()) {
            return patternResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<EmailField, String> validationController = new ValidationController((Component)this);

    public EmailField() {
        super("", "", false, true);
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public EmailField(String label) {
        this();
        this.setLabel(label);
    }

    public EmailField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public EmailField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EmailField, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public EmailField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EmailField, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public EmailField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EmailField, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public void setMaxLength(int maxLength) {
        this.getElement().setProperty("maxlength", (double)maxLength);
    }

    public int getMaxLength() {
        return (int)this.getElement().getProperty("maxlength", 0.0);
    }

    private boolean hasMaxLength() {
        return this.getElement().getProperty("maxlength") != null;
    }

    public void setMinLength(int minLength) {
        this.getElement().setProperty("minlength", (double)minLength);
    }

    public int getMinLength() {
        return (int)this.getElement().getProperty("minlength", 0.0);
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    private boolean hasPattern() {
        return this.getPattern() != null;
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public Validator<String> getDefaultValidator() {
        return this.defaultValidator;
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)this.getValue());
    }

    public EmailFieldI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(EmailFieldI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<EmailFieldI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class EmailFieldI18n
    implements Serializable {
        private String requiredErrorMessage;
        private String minLengthErrorMessage;
        private String maxLengthErrorMessage;
        private String patternErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public EmailFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinLengthErrorMessage() {
            return this.minLengthErrorMessage;
        }

        public EmailFieldI18n setMinLengthErrorMessage(String errorMessage) {
            this.minLengthErrorMessage = errorMessage;
            return this;
        }

        public String getMaxLengthErrorMessage() {
            return this.maxLengthErrorMessage;
        }

        public EmailFieldI18n setMaxLengthErrorMessage(String errorMessage) {
            this.maxLengthErrorMessage = errorMessage;
            return this;
        }

        public String getPatternErrorMessage() {
            return this.patternErrorMessage;
        }

        public EmailFieldI18n setPatternErrorMessage(String errorMessage) {
            this.patternErrorMessage = errorMessage;
            return this;
        }
    }
}

