/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.FieldValidationUtil;
import com.vaadin.flow.component.textfield.GeneratedVaadinTextField;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class TextField
extends GeneratedVaadinTextField<TextField, String>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect,
HasHelper,
HasLabel,
HasClearButton,
HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant>,
HasTooltip,
HasValidator<String>,
HasClientValidation {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;
    private int valueChangeTimeout = 400;
    private TextFieldValidationSupport validationSupport;

    public TextField() {
        this(true);
    }

    private TextField(boolean isInitialValueOptional) {
        super("", "", false, isInitialValueOptional);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
        }
    }

    public TextField(String label) {
        this();
        this.setLabel(label);
    }

    public TextField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public TextField(String label, String initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public TextField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TextField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public TextField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private TextFieldValidationSupport getValidationSupport() {
        if (this.validationSupport == null) {
            this.validationSupport = new TextFieldValidationSupport((HasValue<?, String>)this);
        }
        return this.validationSupport;
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    public boolean isAutoselect() {
        return super.isAutoselectBoolean();
    }

    @Override
    public void setAutoselect(boolean autoselect) {
        super.setAutoselect(autoselect);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public void setMaxLength(int maxLength) {
        super.setMaxlength(maxLength);
        this.getValidationSupport().setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getMaxlengthDouble();
    }

    public void setMinLength(int minLength) {
        super.setMinlength(minLength);
        this.getValidationSupport().setMinLength(minLength);
    }

    public int getMinLength() {
        return (int)this.getMinlengthDouble();
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.getValidationSupport().setRequired(required);
    }

    @Deprecated
    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    @Deprecated
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
        this.getValidationSupport().setPattern(pattern);
    }

    public String getPattern() {
        return this.getPatternString();
    }

    public String getTitle() {
        return super.getTitleString();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.getValidationSupport().setRequired(requiredIndicatorVisible);
    }

    public Validator<String> getDefaultValidator() {
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            return (Validator & Serializable)(value, context) -> this.getValidationSupport().checkValidity((String)value);
        }
        return Validator.alwaysPass();
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<String> listener) {
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
        }
        return null;
    }

    @Override
    protected void validate() {
        this.setInvalid(this.getValidationSupport().isInvalid(this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.isFeatureFlagEnabled(FeatureFlags.ENFORCE_FIELD_VALIDATION)) {
            ClientValidationUtil.preventWebComponentFromSettingItselfToValid((Component)this);
        } else {
            FieldValidationUtil.disableClientValidation((Component)this);
        }
    }

    public void addThemeVariants(TextFieldVariant ... variants) {
        super.addThemeVariants((ThemeVariant[])variants);
    }

    public void removeThemeVariants(TextFieldVariant ... variants) {
        super.removeThemeVariants((ThemeVariant[])variants);
    }

    protected boolean isFeatureFlagEnabled(Feature feature) {
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            return false;
        }
        return FeatureFlags.get((VaadinContext)service.getContext()).isEnabled(feature);
    }
}

