/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

public class NumberField
extends AbstractNumberField<NumberField, Double> {
    public NumberField() {
        this(new Formatter(), true);
    }

    public NumberField(String label) {
        this();
        this.setLabel(label);
    }

    public NumberField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public NumberField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, Double initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private NumberField(Formatter formatter, boolean isInitialValueOptional) {
        super((SerializableFunction & Serializable)x$0 -> formatter.parse((String)x$0), formatter, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, isInitialValueOptional);
    }

    @Override
    public void setMin(double min) {
        super.setMin(min);
    }

    public double getMin() {
        return this.getMinDouble();
    }

    @Override
    public void setMax(double max) {
        super.setMax(max);
    }

    public double getMax() {
        return this.getMaxDouble();
    }

    @Override
    public void setStep(double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep(step);
    }

    public double getStep() {
        return this.getStepDouble();
    }

    @Deprecated
    public void setMaxLength(int maxLength) {
        super.setMaxlength(maxLength);
    }

    @Deprecated
    public int getMaxLength() {
        return (int)this.getMaxlengthDouble();
    }

    @Deprecated
    public void setMinLength(int minLength) {
        super.setMinlength(minLength);
    }

    @Deprecated
    public int getMinLength() {
        return (int)this.getMinlengthDouble();
    }

    @Deprecated
    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    @Deprecated
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    @Override
    @Deprecated
    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }

    @Deprecated
    public String getPattern() {
        return this.getPatternString();
    }

    private static class Formatter
    implements SerializableFunction<Double, String> {
        private final DecimalFormat decimalFormat = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

        private Formatter() {
            this.decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        }

        public String apply(Double valueFromModel) {
            return valueFromModel == null ? "" : this.decimalFormat.format(valueFromModel);
        }

        private Double parse(String valueFromClient) {
            try {
                return valueFromClient == null || valueFromClient.isEmpty() ? null : Double.valueOf(this.decimalFormat.parse(valueFromClient).doubleValue());
            }
            catch (ParseException e) {
                throw new NumberFormatException(valueFromClient);
            }
        }
    }
}

