/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalTime;

@Tests(value={TimePicker.class})
public class TimePickerTester<T extends TimePicker>
extends ComponentTester<T> {
    public TimePickerTester(T component) {
        super(component);
    }

    public void setValue(LocalTime time) {
        this.ensureComponentIsUsable();
        Method isInvalid = this.getMethod("isInvalid", LocalTime.class);
        try {
            if (((Boolean)isInvalid.invoke(this.getComponent(), time)).booleanValue()) {
                throw new IllegalArgumentException("Given time is not a valid value");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ((TimePicker)this.getComponent()).setValue(time);
    }
}

