/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.testbench.unit.mocks.MockHttpSession;
import com.vaadin.testbench.unit.mocks.MockRequest;
import com.vaadin.testbench.unit.mocks.MockResponse;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNumber;
import elemental.json.JsonString;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonValue;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u0016\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010/\u001a\u000200H\u0000\u001a\u0014\u00101\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010/\u001a\u000200H\u0000\u001a\b\u00102\u001a\u00020\u001cH\u0000\u001a\u0012\u00103\u001a\u000204*\u0002052\u0006\u00106\u001a\u000207\u001a\u0012\u00103\u001a\u000204*\u0002052\u0006\u00108\u001a\u00020\u001c\u001a\u0012\u00103\u001a\u000204*\u0002052\u0006\u00109\u001a\u00020:\u001a\u0012\u00103\u001a\u000204*\u0002052\u0006\u0010;\u001a\u000200\u001a\f\u0010<\u001a\u00020\u001c*\u000200H\u0000\u001a\u001e\u0010=\u001a\u0002H>\"\n\b\u0000\u0010>\u0018\u0001*\u00020?*\u00020@H\u0086\b\u00a2\u0006\u0002\u0010A\u001a\u001e\u0010B\u001a\u000200*\u0002002\u0006\u0010C\u001a\u00020\r2\b\b\u0002\u0010B\u001a\u000200H\u0000\u001a\u0016\u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\u0010\u0010E\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\f\u0010F\u001a\u00020\r*\u000200H\u0000\u001a\u001e\u0010G\u001a\u0002H>\"\n\b\u0000\u0010>\u0018\u0001*\u00020?*\u0002H>H\u0086\b\u00a2\u0006\u0002\u0010H\u001a\n\u0010I\u001a\u00020@*\u00020?\u001a\u0012\u0010J\u001a\b\u0012\u0004\u0012\u0002000K*\u000200H\u0000\u001a\u0010\u0010L\u001a\b\u0012\u0004\u0012\u0002070K*\u000205\u001a\f\u0010M\u001a\u0004\u0018\u00010N*\u000207\u001a\u0018\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N0K*\b\u0012\u0004\u0012\u0002070K\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u001a\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0016\u001a\u00020\u0017*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001e\"\u001c\u0010\u001f\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\"*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0015\u0010!\u001a\u00020%*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010&\"\u0015\u0010!\u001a\u00020'*\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010)\"\u0015\u0010*\u001a\u00020\r*\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006O"}, d2={"currentRequest", "Lcom/vaadin/flow/server/VaadinRequest;", "getCurrentRequest", "()Lcom/vaadin/flow/server/VaadinRequest;", "currentResponse", "Lcom/vaadin/flow/server/VaadinResponse;", "getCurrentResponse", "()Lcom/vaadin/flow/server/VaadinResponse;", "currentUI", "Lcom/vaadin/flow/component/UI;", "getCurrentUI", "()Lcom/vaadin/flow/component/UI;", "jvmVersion", "", "getJvmVersion", "()I", "polymerTemplateClass", "Ljava/lang/Class;", "getPolymerTemplateClass", "()Ljava/lang/Class;", "regexWhitespace", "Lkotlin/text/Regex;", "context", "Ljakarta/servlet/ServletContext;", "Lcom/vaadin/flow/server/VaadinContext;", "getContext", "(Lcom/vaadin/flow/server/VaadinContext;)Ljakarta/servlet/ServletContext;", "isInitialized", "", "Ljakarta/servlet/Servlet;", "(Ljakarta/servlet/Servlet;)Z", "isRouteNotFound", "(Ljava/lang/Class;)Z", "mock", "Lcom/vaadin/testbench/unit/mocks/MockRequest;", "getMock", "(Lcom/vaadin/flow/server/VaadinRequest;)Lcom/vaadin/testbench/unit/mocks/MockRequest;", "Lcom/vaadin/testbench/unit/mocks/MockResponse;", "(Lcom/vaadin/flow/server/VaadinResponse;)Lcom/vaadin/testbench/unit/mocks/MockResponse;", "Lcom/vaadin/testbench/unit/mocks/MockHttpSession;", "Lcom/vaadin/flow/server/VaadinSession;", "(Lcom/vaadin/flow/server/VaadinSession;)Lcom/vaadin/testbench/unit/mocks/MockHttpSession;", "size", "Lkotlin/ranges/IntRange;", "getSize", "(Lkotlin/ranges/IntRange;)I", "findClass", "className", "", "findClassOrThrow", "hasPolymerTemplates", "add", "", "Lelemental/json/JsonArray;", "value", "Lelemental/json/JsonValue;", "bool", "number", "", "string", "containsWhitespace", "deserialize", "T", "Ljava/io/Serializable;", "", "([B)Ljava/io/Serializable;", "ellipsize", "maxLength", "getErrorParameterType", "hasCustomToString", "parseJvmVersion", "serializeDeserialize", "(Ljava/io/Serializable;)Ljava/io/Serializable;", "serializeToBytes", "splitByWhitespaces", "", "toList", "unwrap", "", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/vaadin/testbench/unit/internal/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,219:1\n46#1:221\n1#2:220\n1549#3:222\n1620#3,3:223\n1549#3:226\n1620#3,3:227\n819#3:235\n847#3,2:236\n643#4,5:230\n1083#4,2:238\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/vaadin/testbench/unit/internal/UtilsKt\n*L\n49#1:221\n87#1:222\n87#1:223,3\n93#1:226\n93#1:227,3\n120#1:235\n120#1:236,2\n114#1:230,5\n122#1:238,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Regex regexWhitespace = new Regex("\\s+");
    @Nullable
    private static final Class<?> polymerTemplateClass = UtilsKt.findClass("com.vaadin.flow.component.polymertemplate.PolymerTemplate");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] serializeToBytes(@NotNull Serializable $this$serializeToBytes) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$serializeToBytes, (String)"<this>");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            new ObjectOutputStream(it).writeObject($this$serializeToBytes);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = var3_3.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static final /* synthetic */ <T extends Serializable> T deserialize(byte[] $this$deserialize) {
        Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
        boolean $i$f$deserialize = false;
        Object object = new ObjectInputStream(new ByteArrayInputStream($this$deserialize)).readObject();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)((Serializable)object);
    }

    public static final /* synthetic */ <T extends Serializable> T serializeDeserialize(T $this$serializeDeserialize) {
        Intrinsics.checkNotNullParameter($this$serializeDeserialize, (String)"<this>");
        boolean $i$f$serializeDeserialize = false;
        byte[] $this$deserialize$iv = UtilsKt.serializeToBytes($this$serializeDeserialize);
        boolean $i$f$deserialize = false;
        Object object = new ObjectInputStream(new ByteArrayInputStream($this$deserialize$iv)).readObject();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)((Serializable)object);
    }

    public static final int getSize(@NotNull IntRange $this$size) {
        Intrinsics.checkNotNullParameter((Object)$this$size, (String)"<this>");
        return RangesKt.coerceAtLeast((int)($this$size.getEndInclusive() + 1 - $this$size.getStart()), (int)0);
    }

    public static final void add(@NotNull JsonArray $this$add, @NotNull JsonValue value) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$add.set($this$add.length(), value);
    }

    public static final void add(@NotNull JsonArray $this$add, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JsonString jsonString = Json.create((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)jsonString, (String)"create(...)");
        UtilsKt.add($this$add, (JsonValue)jsonString);
    }

    public static final void add(@NotNull JsonArray $this$add, boolean bool) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        JsonBoolean jsonBoolean = Json.create((boolean)bool);
        Intrinsics.checkNotNullExpressionValue((Object)jsonBoolean, (String)"create(...)");
        UtilsKt.add($this$add, (JsonValue)jsonBoolean);
    }

    public static final void add(@NotNull JsonArray $this$add, double number) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        JsonNumber jsonNumber = Json.create((double)number);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNumber, (String)"create(...)");
        UtilsKt.add($this$add, (JsonValue)jsonNumber);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsonValue> toList(@NotNull JsonArray $this$toList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toList, (String)"<this>");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$toList.length());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$toList.get((int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> unwrap(@NotNull List<? extends JsonValue> $this$unwrap) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$unwrap, (String)"<this>");
        Iterable $this$map$iv = $this$unwrap;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonValue jsonValue = (JsonValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.unwrap((JsonValue)it));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Object unwrap(@NotNull JsonValue $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return $this$unwrap instanceof JsonArray ? UtilsKt.unwrap(UtilsKt.toList((JsonArray)$this$unwrap)) : ((JreJsonValue)$this$unwrap).getObject();
    }

    public static final int getJvmVersion() {
        String string = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return UtilsKt.parseJvmVersion(string);
    }

    /*
     * WARNING - void declaration
     */
    public static final int parseJvmVersion(@NotNull String $this$parseJvmVersion) {
        String string;
        block1: {
            void var2_1;
            Intrinsics.checkNotNullParameter((Object)$this$parseJvmVersion, (String)"<this>");
            String $this$takeWhile$iv = StringsKt.removePrefix((String)$this$parseJvmVersion, (CharSequence)"1.");
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Character.isDigit(it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_1;
        }
        void version = string;
        return Integer.parseInt((String)version);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> splitByWhitespaces(@NotNull String $this$splitByWhitespaces) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespaces, (String)"<this>");
        CharSequence charSequence = $this$splitByWhitespaces;
        Regex regex = regexWhitespace;
        int n = 0;
        Iterable $this$filterNot$iv = regex.split(charSequence, n);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean containsWhitespace(@NotNull String $this$containsWhitespace) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$containsWhitespace, (String)"<this>");
            CharSequence $this$any$iv = $this$containsWhitespace;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize, int maxLength, @NotNull String ellipsize) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ellipsize, (String)"ellipsize");
        if (!(maxLength >= ellipsize.length())) {
            boolean bl = false;
            String string = "maxLength must be at least the size of ellipsize " + ellipsize + " but it was " + maxLength;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$ellipsize.length() <= maxLength || $this$ellipsize.length() <= ellipsize.length() ? $this$ellipsize : StringsKt.take((String)$this$ellipsize, (int)(maxLength - ellipsize.length())) + ellipsize;
    }

    public static /* synthetic */ String ellipsize$default(String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = "...";
        }
        return UtilsKt.ellipsize(string, n, string2);
    }

    @Nullable
    public static final Class<?> getErrorParameterType(@NotNull Class<?> $this$getErrorParameterType) {
        Intrinsics.checkNotNullParameter($this$getErrorParameterType, (String)"<this>");
        return ReflectTools.getGenericInterfaceType($this$getErrorParameterType, HasErrorParameter.class);
    }

    public static final boolean isRouteNotFound(@NotNull Class<?> $this$isRouteNotFound) {
        Intrinsics.checkNotNullParameter($this$isRouteNotFound, (String)"<this>");
        return Intrinsics.areEqual(UtilsKt.getErrorParameterType($this$isRouteNotFound), NotFoundException.class);
    }

    @NotNull
    public static final VaadinRequest getCurrentRequest() {
        VaadinRequest vaadinRequest = VaadinService.getCurrentRequest();
        if (vaadinRequest == null) {
            throw new IllegalStateException("No current request. Have you called MockVaadin.setup()?");
        }
        return vaadinRequest;
    }

    @NotNull
    public static final VaadinResponse getCurrentResponse() {
        VaadinResponse vaadinResponse = VaadinService.getCurrentResponse();
        if (vaadinResponse == null) {
            throw new IllegalStateException("No current response. Have you called MockVaadin.setup()?");
        }
        return vaadinResponse;
    }

    @NotNull
    public static final UI getCurrentUI() {
        UI uI = UI.getCurrent();
        if (uI == null) {
            throw new IllegalStateException("UI.getCurrent() is null. Have you called MockVaadin.setup()?");
        }
        return uI;
    }

    @NotNull
    public static final MockRequest getMock(@NotNull VaadinRequest $this$mock) {
        Intrinsics.checkNotNullParameter((Object)$this$mock, (String)"<this>");
        ServletRequest servletRequest = ((VaadinServletRequest)$this$mock).getRequest();
        Intrinsics.checkNotNull((Object)servletRequest, (String)"null cannot be cast to non-null type com.vaadin.testbench.unit.mocks.MockRequest");
        return (MockRequest)servletRequest;
    }

    @NotNull
    public static final MockResponse getMock(@NotNull VaadinResponse $this$mock) {
        Intrinsics.checkNotNullParameter((Object)$this$mock, (String)"<this>");
        ServletResponse servletResponse = ((VaadinServletResponse)$this$mock).getResponse();
        Intrinsics.checkNotNull((Object)servletResponse, (String)"null cannot be cast to non-null type com.vaadin.testbench.unit.mocks.MockResponse");
        return (MockResponse)servletResponse;
    }

    @NotNull
    public static final MockHttpSession getMock(@NotNull VaadinSession $this$mock) {
        Intrinsics.checkNotNullParameter((Object)$this$mock, (String)"<this>");
        WrappedSession wrappedSession = $this$mock.getSession();
        Intrinsics.checkNotNull((Object)wrappedSession, (String)"null cannot be cast to non-null type com.vaadin.flow.server.WrappedHttpSession");
        HttpSession httpSession = ((WrappedHttpSession)wrappedSession).getHttpSession();
        Intrinsics.checkNotNull((Object)httpSession, (String)"null cannot be cast to non-null type com.vaadin.testbench.unit.mocks.MockHttpSession");
        return (MockHttpSession)httpSession;
    }

    @NotNull
    public static final ServletContext getContext(@NotNull VaadinContext $this$context) {
        Intrinsics.checkNotNullParameter((Object)$this$context, (String)"<this>");
        ServletContext servletContext = ((VaadinServletContext)$this$context).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getContext(...)");
        return servletContext;
    }

    public static final boolean isInitialized(@NotNull Servlet $this$isInitialized) {
        Intrinsics.checkNotNullParameter((Object)$this$isInitialized, (String)"<this>");
        return $this$isInitialized.getServletConfig() != null;
    }

    public static final boolean hasCustomToString(@NotNull Class<?> $this$hasCustomToString) {
        Intrinsics.checkNotNullParameter($this$hasCustomToString, (String)"<this>");
        return !Intrinsics.areEqual($this$hasCustomToString.getMethod("toString", new Class[0]).getDeclaringClass(), Object.class);
    }

    @Nullable
    public static final Class<?> getPolymerTemplateClass() {
        return polymerTemplateClass;
    }

    public static final boolean hasPolymerTemplates() {
        return polymerTemplateClass != null;
    }

    @Nullable
    public static final Class<?> findClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex2) {
                return null;
            }
        }
    }

    @NotNull
    public static final Class<?> findClassOrThrow(@NotNull String className) throws ClassNotFoundException {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Class<?> clazz = UtilsKt.findClass(className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }
}

