/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.function.Consumer;

@Tests(value={TextArea.class})
public class TextAreaTester<T extends TextArea>
extends ComponentTester<T> {
    public TextAreaTester(T component) {
        super(component);
    }

    public void setValue(String value) {
        this.ensureComponentIsUsable();
        this.setValueAsUser(value);
    }

    private boolean hasValidation() {
        return this.getValidationSupport() != null;
    }

    private TextFieldValidationSupport getValidationSupport() {
        try {
            return (TextFieldValidationSupport)this.getField("validationSupport").get(this.getComponent());
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((TextArea)this.getComponent()).isReadOnly();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((TextArea)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
    }
}

