/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.listbox.MultiSelectListBox;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Tests(fqn={"com.vaadin.flow.component.listbox.MultiSelectListBox"})
public class MultiSelectListBoxTester<T extends MultiSelectListBox<V>, V>
extends ComponentTester<T> {
    public MultiSelectListBoxTester(T component) {
        super(component);
    }

    public Set<V> getSelected() {
        return (Set)((MultiSelectListBox)this.getComponent()).getValue();
    }

    public void selectItems(String ... selection) {
        Objects.requireNonNull(selection, "Can not select null");
        this.ensureComponentIsUsable();
        Set<V> items = this.getItemsForSelection(selection);
        items.addAll(this.getSelected());
        this.setValueAsUser(items);
    }

    public void deselectItems(String ... selection) {
        Objects.requireNonNull(selection, "Can not deselect null");
        this.ensureComponentIsUsable();
        Set items = this.getItemsForSelection(selection);
        Set value = this.getSelected().stream().filter(item -> !items.contains(item)).collect(Collectors.toSet());
        this.setValueAsUser(value);
    }

    private Set<V> getItemsForSelection(String[] selection) {
        List<String> items = Arrays.asList(selection);
        Set filtered = this.getSuggestionItems().stream().filter(item -> items.contains(this.getItemLabel(item))).collect(Collectors.toSet());
        if (filtered.size() != items.size()) {
            throw new IllegalArgumentException("Selection contained items that didn't have a selection");
        }
        return filtered;
    }

    public void clearSelection() {
        ((MultiSelectListBox)this.getComponent()).clear();
    }

    public List<String> getSuggestions() {
        List<V> suggestionItems = this.getSuggestionItems();
        return suggestionItems.stream().map(this::getItemLabel).collect(Collectors.toList());
    }

    private String getItemLabel(V item) {
        ItemLabelGenerator itemLabelGenerator = ((MultiSelectListBox)this.getComponent()).getItemLabelGenerator();
        if (itemLabelGenerator != null) {
            return itemLabelGenerator.apply(item);
        }
        return item.toString();
    }

    public List<V> getSuggestionItems() {
        return ((MultiSelectListBox)this.getComponent()).getGenericDataView().getItems().collect(Collectors.toList());
    }
}

