/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.charts.Chart;
import com.vaadin.flow.component.charts.events.ChartClickEvent;
import com.vaadin.flow.component.charts.events.PointClickEvent;
import com.vaadin.flow.component.charts.events.SeriesClickEvent;
import com.vaadin.flow.component.charts.events.SeriesLegendItemClickEvent;
import com.vaadin.flow.component.charts.model.AbstractSeriesItem;
import com.vaadin.flow.component.charts.model.DataProviderSeries;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.ListSeries;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tests(value={Chart.class})
public class ChartTester<T extends Chart>
extends ComponentTester<T> {
    public ChartTester(T component) {
        super(component);
    }

    public List<Number> getSeriesValues(int seriesIndex) {
        this.ensureComponentIsUsable();
        Series series = (Series)((Chart)this.getComponent()).getConfiguration().getSeries().get(seriesIndex);
        return this.getValuesFromSeries(series);
    }

    public List<Number> getSeriesValues(String seriesName) {
        this.ensureComponentIsUsable();
        Objects.requireNonNull(seriesName, "series name must not be null");
        Series series = this.findSeriesByName(seriesName);
        return this.getValuesFromSeries(series);
    }

    public Number getPointValue(int seriesIndex, String name) {
        this.ensureComponentIsUsable();
        Series series = (Series)((Chart)this.getComponent()).getConfiguration().getSeries().get(seriesIndex);
        return this.getPointValueFromSeries(series, name);
    }

    public Number getPointValue(String seriesName, String name) {
        this.ensureComponentIsUsable();
        Series series = this.findSeriesByName(seriesName);
        return this.getPointValueFromSeries(series, name);
    }

    public void clickLegendItem(String item) {
        this.ensureComponentIsUsable();
        Series series = this.findSeriesByName(item);
        Chart component = (Chart)this.getComponent();
        int seriesIndex = component.getConfiguration().getSeries().indexOf(series);
        ComponentUtil.fireEvent((Component)component, (ComponentEvent)new SeriesLegendItemClickEvent(component, true, 0, 0, false, false, false, false, 0, seriesIndex));
    }

    public void clickPoint(String seriesName, String name) {
        this.ensureComponentIsUsable();
        Chart component = (Chart)this.getComponent();
        Series series = this.findSeriesByName(seriesName);
        int seriesIndex = component.getConfiguration().getSeries().indexOf(series);
        Point point = this.getPointFromSeries(series, name);
        ComponentUtil.fireEvent((Component)component, (ComponentEvent)new SeriesClickEvent(component, true, 0, 0, false, false, false, false, 0, 0.0, 0.0, seriesIndex));
        String category = Stream.of(((Chart)this.getComponent()).getConfiguration().getxAxis().getCategories()).filter(name::equals).findFirst().orElse(null);
        ComponentUtil.fireEvent((Component)component, (ComponentEvent)new PointClickEvent(component, true, 0, 0, false, false, false, false, 0, 0.0, 0.0, seriesIndex, category, point.index, point.id));
    }

    public void clickChart() {
        this.ensureComponentIsUsable();
        Chart component = (Chart)this.getComponent();
        ComponentUtil.fireEvent((Component)component, (ComponentEvent)new ChartClickEvent(component, true, Double.valueOf(0.0), Double.valueOf(0.0), 0, 0, false, false, false, false, 0));
    }

    private Series findSeriesByName(String seriesName) {
        return ((Chart)this.getComponent()).getConfiguration().getSeries().stream().filter(s -> seriesName.equals(s.getName())).reduce((s1, s2) -> {
            throw new IllegalStateException("Multiple series found with name " + seriesName);
        }).orElseThrow(() -> new IllegalArgumentException("Series " + seriesName + " does not exists"));
    }

    List<Number> getValuesFromSeries(Series series) {
        if (series instanceof ListSeries) {
            return new ArrayList<Number>(List.of(((ListSeries)series).getData()));
        }
        if (series instanceof DataSeries) {
            return ((DataSeries)series).getData().stream().map(AbstractSeriesItem::getY).collect(Collectors.toList());
        }
        if (series instanceof DataProviderSeries) {
            return ((DataProviderSeries)series).getValues().stream().map(map -> map.getOrDefault("y", Optional.empty()).map(Number.class::cast).orElseThrow()).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Getting values from series of type " + series.getClass().getName() + " is not supported");
    }

    Number getPointValueFromSeries(Series series, String name) {
        return this.getPointFromSeries((Series)series, (String)name).value;
    }

    private Point getPointFromSeries(Series series, String name) {
        if (series instanceof ListSeries) {
            List<String> categories = List.of(((Chart)this.getComponent()).getConfiguration().getxAxis().getCategories());
            if (categories.isEmpty()) {
                throw new IllegalStateException("X-Axis categories not configured");
            }
            int index = categories.indexOf(name);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid X-Axis category " + name + ". Existing categories are " + String.join((CharSequence)", ", categories));
            }
            if (categories.lastIndexOf(name) != index) {
                throw new IllegalStateException("Found multiple items with same X-Axis name: " + name);
            }
            return new Point(String.format("highcharts-%s-%s", name, index), index, ((ListSeries)series).getData()[index]);
        }
        if (series instanceof DataSeries) {
            DataSeries cast = (DataSeries)series;
            DataSeriesItem item = cast.get(name);
            if (item == null) {
                String names = cast.getData().stream().map(AbstractSeriesItem::getName).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("Invalid DataSeriesItem name " + name + ". Existing names are " + names);
            }
            int pointIndex = cast.getData().indexOf(item);
            String pointId = cast.getId();
            if (pointId == null) {
                pointId = String.format("highcharts-%s-%s", name, pointIndex);
            }
            return new Point(pointId, pointIndex, item.getY());
        }
        if (series instanceof DataProviderSeries) {
            List allValues = ((DataProviderSeries)series).getValues();
            List pointAttributes = allValues.stream().filter(map -> name.equals(((Optional)map.get("x")).orElse(null))).collect(Collectors.toList());
            if (pointAttributes.isEmpty()) {
                throw new IllegalArgumentException("Cannot find point. Invalid name for X-Axis: " + name);
            }
            if (pointAttributes.size() > 1) {
                throw new IllegalStateException("Found multiple items with same X-Axis name: " + name);
            }
            Map map2 = (Map)pointAttributes.get(0);
            Number value = ((Optional)map2.get("y")).map(Number.class::cast).orElse(null);
            int pointIndex = allValues.indexOf(map2);
            return new Point(String.format("highcharts-%s-%s", name, pointIndex), pointIndex, value);
        }
        throw new UnsupportedOperationException("Getting values from series of type " + series.getClass().getName() + " is not supported");
    }

    private static class Point {
        private String id;
        private final int index;
        private final Number value;

        Point(String id, int index, Number value) {
            this.id = id;
            this.index = index;
            this.value = value;
        }
    }
}

