/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.mocks;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import com.vaadin.testbench.unit.internal.UtilsKt;
import com.vaadin.testbench.unit.mocks.MockContext;
import com.vaadin.testbench.unit.mocks.MockVaadinHelper;
import elemental.json.Json;
import elemental.json.JsonObject;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0012\b\u0002\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0012\b\u0002\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u000f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\rJ\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/vaadin/testbench/unit/mocks/MockVaadinHelper;", "", "()V", "flowBuildInfo", "Lelemental/json/JsonObject;", "getFlowBuildInfo", "()Lelemental/json/JsonObject;", "flowBuildInfo$delegate", "Lkotlin/Lazy;", "createMockContext", "Ljakarta/servlet/ServletContext;", "lookupServices", "", "Ljava/lang/Class;", "createMockVaadinContext", "Lcom/vaadin/flow/server/VaadinContext;", "getTokenFileFromClassloader", "init", "", "ctx", "lookup", "clazz", "mockFlowBuildInfo", "servlet", "Lcom/vaadin/flow/server/VaadinServlet;", "verifyHasLookup", "Lcom/vaadin/flow/di/Lookup;", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nMockVaadinHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockVaadinHelper.kt\ncom/vaadin/testbench/unit/mocks/MockVaadinHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,120:1\n1#2:121\n37#3,2:122\n*S KotlinDebug\n*F\n+ 1 MockVaadinHelper.kt\ncom/vaadin/testbench/unit/mocks/MockVaadinHelper\n*L\n100#1:122,2\n*E\n"})
public final class MockVaadinHelper {
    @NotNull
    public static final MockVaadinHelper INSTANCE = new MockVaadinHelper();
    @NotNull
    private static final Lazy flowBuildInfo$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)flowBuildInfo.2.INSTANCE);

    private MockVaadinHelper() {
    }

    private final JsonObject getFlowBuildInfo() {
        Lazy lazy = flowBuildInfo$delegate;
        return (JsonObject)lazy.getValue();
    }

    @JvmStatic
    public static final void mockFlowBuildInfo(@NotNull VaadinServlet servlet) {
        Intrinsics.checkNotNullParameter((Object)servlet, (String)"servlet");
        if (INSTANCE.getFlowBuildInfo() == null) {
            File file = File.createTempFile("flow-build-info", "json");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File tokenFile = file;
            FilesKt.writeText$default((File)tokenFile, (String)"{}", null, (int)2, null);
            servlet.getServletContext().setInitParameter("vaadin.frontend.token.file", tokenFile.getAbsolutePath());
        }
        servlet.getServletContext().setInitParameter("compatibilityMode", "false");
    }

    @NotNull
    public final ServletContext createMockContext(@NotNull Set<? extends Class<?>> lookupServices) {
        Intrinsics.checkNotNullParameter(lookupServices, (String)"lookupServices");
        MockContext ctx = new MockContext();
        this.init(ctx, lookupServices);
        return ctx;
    }

    public static /* synthetic */ ServletContext createMockContext$default(MockVaadinHelper mockVaadinHelper, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        return mockVaadinHelper.createMockContext(set);
    }

    @NotNull
    public final VaadinContext createMockVaadinContext() {
        return (VaadinContext)new VaadinServletContext(MockVaadinHelper.createMockContext$default(this, null, 1, null));
    }

    @Nullable
    public final JsonObject getTokenFileFromClassloader() {
        VaadinContext ctx = INSTANCE.createMockVaadinContext();
        Object acf = this.lookup(ctx, UtilsKt.findClassOrThrow("com.vaadin.flow.server.startup.ApplicationConfigurationFactory"));
        if (acf == null) {
            boolean $i$a$-checkNotNull-MockVaadinHelper$getTokenFileFromClassloader$22 = false;
            String $i$a$-checkNotNull-MockVaadinHelper$getTokenFileFromClassloader$22 = "ApplicationConfigurationFactory is null";
            throw new IllegalStateException($i$a$-checkNotNull-MockVaadinHelper$getTokenFileFromClassloader$22.toString());
        }
        Class<?> dacfClass = UtilsKt.findClassOrThrow("com.vaadin.flow.server.startup.DefaultApplicationConfigurationFactory");
        if (dacfClass.isInstance(acf)) {
            Class[] classArray = new Class[]{VaadinContext.class};
            Method m = dacfClass.getDeclaredMethod("getTokenFileFromClassloader", classArray);
            m.setAccessible(true);
            Object[] objectArray = new Object[]{ctx};
            String string = (String)m.invoke(acf, objectArray);
            if (string == null) {
                return null;
            }
            String json = string;
            return Json.parse((String)json);
        }
        return null;
    }

    @Nullable
    public final Object lookup(@NotNull VaadinContext ctx, @NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Lookup lookup = this.verifyHasLookup(ctx);
        return lookup.lookup(clazz);
    }

    private final Lookup verifyHasLookup(ServletContext ctx) {
        Object lookup = ctx.getAttribute("com.vaadin.flow.di.Lookup");
        if (lookup == null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("The context doesn't contain the Vaadin 19 Lookup class. Available attributes: ");
            Enumeration enumeration = ctx.getAttributeNames();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getAttributeNames(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            String string = stringBuilder.append(arrayList).toString();
            throw new IllegalStateException(string.toString());
        }
        return (Lookup)lookup;
    }

    private final Lookup verifyHasLookup(VaadinContext ctx) {
        Intrinsics.checkNotNull((Object)ctx, (String)"null cannot be cast to non-null type com.vaadin.flow.server.VaadinServletContext");
        ServletContext servletContext = ((VaadinServletContext)ctx).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getContext(...)");
        return this.verifyHasLookup(servletContext);
    }

    private final void init(ServletContext ctx, Set<? extends Class<?>> lookupServices) {
        LookupServletContainerInitializer loaderInitializer = new LookupServletContainerInitializer();
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        Collection $this$toTypedArray$iv = lookupServices;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Class[0]));
        spreadBuilder.add(LookupInitializer.class);
        spreadBuilder.add(UtilsKt.findClassOrThrow("com.vaadin.flow.di.LookupInitializer$ResourceProviderImpl"));
        Set loaders = SetsKt.mutableSetOf((Object[])spreadBuilder.toArray((Object[])new Class[spreadBuilder.size()]));
        MockVaadinHelper.init$tryLoad(loaders, "com.vaadin.flow.component.polymertemplate.rpc.PolymerPublishedEventRpcHandler");
        MockVaadinHelper.init$tryLoad(loaders, "com.vaadin.fusion.frontend.EndpointGeneratorTaskFactoryImpl");
        loaderInitializer.onStartup(loaders, ctx);
        this.verifyHasLookup(ctx);
    }

    static /* synthetic */ void init$default(MockVaadinHelper mockVaadinHelper, ServletContext servletContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        mockVaadinHelper.init(servletContext, set);
    }

    private static final void init$tryLoad(Set<Class<?>> loaders, String className) {
        block0: {
            Class<?> clazz = UtilsKt.findClass(className);
            if (clazz == null) break block0;
            Class<?> clazz2 = clazz;
            boolean bl = false;
            loaders.add(clazz2);
        }
    }
}

