/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.DefaultErrorHandler;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.testbench.unit.internal.BasicUtilsKt;
import com.vaadin.testbench.unit.internal.MockPage;
import com.vaadin.testbench.unit.internal.MockRequestCustomizer;
import com.vaadin.testbench.unit.internal.MockVaadinKt;
import com.vaadin.testbench.unit.internal.Routes;
import com.vaadin.testbench.unit.internal.TestingLifecycleHookKt;
import com.vaadin.testbench.unit.internal.UIFactory;
import com.vaadin.testbench.unit.internal.UtilsKt;
import com.vaadin.testbench.unit.mocks.MockHttpSession;
import com.vaadin.testbench.unit.mocks.MockRequest;
import com.vaadin.testbench.unit.mocks.MockResponse;
import com.vaadin.testbench.unit.mocks.MockServletConfig;
import com.vaadin.testbench.unit.mocks.MockVaadinHelper;
import com.vaadin.testbench.unit.mocks.MockVaadinServlet;
import com.vaadin.testbench.unit.mocks.MockVaadinServletKt;
import com.vaadin.testbench.unit.mocks.MockedUI;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0012\b\u0002\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0007J.\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0012\b\u0002\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0007J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0010H\u0007J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u0010H\u0002J\u0018\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u0002012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001d\u00102\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020\u0010H\u0007J\u001c\u00106\u001a\u00020\u00102\b\b\u0002\u00107\u001a\u00020\u001c2\b\b\u0002\u00103\u001a\u00020\u0006H\u0007J\u0018\u00108\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00069"}, d2={"Lcom/vaadin/testbench/unit/internal/MockVaadin;", "", "<init>", "()V", "strongRefSession", "Ljava/lang/ThreadLocal;", "Lcom/vaadin/flow/server/VaadinSession;", "strongRefUI", "Lcom/vaadin/flow/component/UI;", "strongRefReq", "Lcom/vaadin/flow/server/VaadinRequest;", "strongRefRes", "Lcom/vaadin/flow/server/VaadinResponse;", "lastNavigation", "Lcom/vaadin/flow/router/Location;", "setup", "", "routes", "Lcom/vaadin/testbench/unit/internal/Routes;", "uiFactory", "Lcom/vaadin/testbench/unit/internal/UIFactory;", "lookupServices", "", "Ljava/lang/Class;", "servlet", "Lcom/vaadin/flow/server/VaadinServlet;", "closeCurrentUI", "fireUIDetach", "", "tearDown", "clearVaadinInstances", "closeCurrentSession", "currentlyClosingSession", "userAgent", "", "getUserAgent", "()Ljava/lang/String;", "setUserAgent", "(Ljava/lang/String;)V", "mockRequestFactory", "Lkotlin/Function1;", "Lcom/vaadin/testbench/unit/mocks/MockHttpSession;", "Lcom/vaadin/testbench/unit/mocks/MockRequest;", "getMockRequestFactory", "()Lkotlin/jvm/functions/Function1;", "setMockRequestFactory", "(Lkotlin/jvm/functions/Function1;)V", "createSession", "ctx", "Ljakarta/servlet/ServletContext;", "createUI", "session", "createUI$vaadin_testbench_unit_shared", "clientRoundtrip", "runUIQueue", "propagateExceptionToHandler", "afterSessionClose", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nMockVaadin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockVaadin.kt\ncom/vaadin/testbench/unit/internal/MockVaadin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,449:1\n1#2:450\n1869#3,2:451\n*S KotlinDebug\n*F\n+ 1 MockVaadin.kt\ncom/vaadin/testbench/unit/internal/MockVaadin\n*L\n364#1:451,2\n*E\n"})
public final class MockVaadin {
    @NotNull
    public static final MockVaadin INSTANCE = new MockVaadin();
    @NotNull
    private static final ThreadLocal<VaadinSession> strongRefSession = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<UI> strongRefUI = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<VaadinRequest> strongRefReq = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<VaadinResponse> strongRefRes = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<Location> lastNavigation = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<Boolean> currentlyClosingSession = new ThreadLocal<Boolean>(){

        protected Boolean initialValue() {
            return false;
        }
    };
    @NotNull
    private static String userAgent = "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:94.0) Gecko/20100101 Firefox/94.0";
    @NotNull
    private static Function1<? super MockHttpSession, ? extends MockRequest> mockRequestFactory = MockVaadin::mockRequestFactory$lambda$0;

    private MockVaadin() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull Routes routes, @NotNull UIFactory uiFactory, @NotNull Set<? extends Class<?>> lookupServices) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        Intrinsics.checkNotNullParameter((Object)uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter(lookupServices, (String)"lookupServices");
        MockVaadinServlet servlet = new MockVaadinServlet(routes, null, 2, null);
        MockVaadin.setup(uiFactory, servlet, lookupServices);
    }

    public static /* synthetic */ void setup$default(Routes routes, UIFactory uIFactory, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            routes = new Routes(null, null, false, 7, null);
        }
        if ((n & 2) != 0) {
            uIFactory = MockVaadin::setup$lambda$0;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        MockVaadin.setup(routes, uIFactory, set);
    }

    @JvmStatic
    public static final void setup(@NotNull UIFactory uiFactory, @NotNull VaadinServlet servlet, @NotNull Set<? extends Class<?>> lookupServices) {
        Intrinsics.checkNotNullParameter((Object)uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter((Object)servlet, (String)"servlet");
        Intrinsics.checkNotNullParameter(lookupServices, (String)"lookupServices");
        if (!UtilsKt.isInitialized((Servlet)servlet)) {
            ServletContext ctx = MockVaadinHelper.INSTANCE.createMockContext(lookupServices);
            servlet.init((ServletConfig)new MockServletConfig(ctx));
        }
        VaadinServletService vaadinServletService = MockVaadinServletKt.getServiceSafe(servlet);
        if (vaadinServletService == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        VaadinServletService service = vaadinServletService;
        if (!(service.getRouter() != null)) {
            boolean bl = false;
            String string = servlet + " failed to call VaadinServletService.init() in createServletService()";
            throw new IllegalStateException(string.toString());
        }
        VaadinService.setCurrent((VaadinService)((VaadinService)service));
        ServletContext servletContext = servlet.getServletContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getServletContext(...)");
        INSTANCE.createSession(servletContext, uiFactory);
    }

    public static /* synthetic */ void setup$default(UIFactory uIFactory, VaadinServlet vaadinServlet, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            uIFactory = MockVaadin::setup$lambda$1;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        MockVaadin.setup(uIFactory, vaadinServlet, set);
    }

    public final void closeCurrentUI(boolean fireUIDetach) {
        UI uI = UI.getCurrent();
        if (uI == null) {
            return;
        }
        UI ui = uI;
        lastNavigation.set(ui.getInternals().getActiveViewLocation());
        if (ui.isClosing() && ui.getInternals().getSession() != null) {
            BasicUtilsKt._close(ui);
        }
        if (fireUIDetach) {
            ComponentUtil.onComponentDetach((Component)((Component)ui));
        }
        UI.setCurrent(null);
        strongRefUI.remove();
    }

    @JvmStatic
    public static final void tearDown() {
        INSTANCE.clearVaadinInstances(false);
        VaadinService service = VaadinService.getCurrent();
        if (service != null) {
            MockVaadinKt.access$fireServiceDestroyListeners(service, new ServiceDestroyEvent(service));
            VaadinService.setCurrent(null);
        }
        lastNavigation.remove();
    }

    private final void clearVaadinInstances(boolean fireUIDetach) {
        this.closeCurrentUI(fireUIDetach);
        this.closeCurrentSession();
        CurrentInstance.set(VaadinRequest.class, null);
        CurrentInstance.set(VaadinResponse.class, null);
        strongRefReq.remove();
        strongRefRes.remove();
    }

    private final void closeCurrentSession() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session != null) {
            VaadinService vaadinService = VaadinService.getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)vaadinService, (String)"getCurrent(...)");
            VaadinService service = vaadinService;
            service.fireSessionDestroy(session);
            VaadinSession.setCurrent(null);
            currentlyClosingSession.set(true);
            MockVaadin.runUIQueue$default(false, session, 1, null);
            currentlyClosingSession.set(false);
        }
        strongRefSession.remove();
    }

    @NotNull
    public final String getUserAgent() {
        return userAgent;
    }

    public final void setUserAgent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        userAgent = string;
    }

    @NotNull
    public final Function1<MockHttpSession, MockRequest> getMockRequestFactory() {
        return mockRequestFactory;
    }

    public final void setMockRequestFactory(@NotNull Function1<? super MockHttpSession, ? extends MockRequest> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        mockRequestFactory = function1;
    }

    /*
     * WARNING - void declaration
     */
    private final void createSession(ServletContext ctx, UIFactory uiFactory) {
        void $this$createSession_u24lambda_u240;
        ReentrantLock reentrantLock;
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)vaadinService, (String)"null cannot be cast to non-null type com.vaadin.flow.server.VaadinServletService");
        VaadinServletService service = (VaadinServletService)vaadinService;
        MockHttpSession httpSession = MockHttpSession.Companion.create(ctx);
        MockRequest mockRequest = (MockRequest)mockRequestFactory.invoke((Object)httpSession);
        ((Map)mockRequest.getHeaders()).put("User-Agent", CollectionsKt.listOf((Object)userAgent));
        MockRequestCustomizer mockRequestCustomizer = (MockRequestCustomizer)((Lookup)service.getContext().getAttribute(Lookup.class)).lookup(MockRequestCustomizer.class);
        if (mockRequestCustomizer != null) {
            mockRequestCustomizer.apply(mockRequest);
        }
        VaadinServletRequest request = MockVaadinServletKt.createVaadinServletRequest(mockRequest, (VaadinService)service);
        strongRefReq.set((VaadinRequest)request);
        CurrentInstance.set(VaadinRequest.class, (Object)request);
        VaadinService vaadinService2 = (VaadinService)service;
        VaadinRequest vaadinRequest = VaadinRequest.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)vaadinRequest, (String)"getCurrent(...)");
        VaadinSession session = MockVaadinServletKt._createVaadinSession(vaadinService2, vaadinRequest);
        ReentrantLock reentrantLock2 = reentrantLock = new ReentrantLock();
        String string = service.getServiceName() + ".lock";
        MockHttpSession mockHttpSession = httpSession;
        boolean bl = false;
        $this$createSession_u24lambda_u240.lock();
        Unit unit = Unit.INSTANCE;
        mockHttpSession.setAttribute(string, reentrantLock);
        httpSession.setAttribute(VaadinSession.class.getName() + '.' + service.getServiceName(), session);
        session.refreshTransients((WrappedSession)new WrappedHttpSession((HttpSession)httpSession), (VaadinService)service);
        if (!(session.getLockInstance() != null)) {
            boolean $i$a$-check-MockVaadin$createSession$42 = false;
            String $i$a$-check-MockVaadin$createSession$42 = session + " created from " + service + " has null lock. See the MockSession class on how to mock locks properly";
            throw new IllegalStateException($i$a$-check-MockVaadin$createSession$42.toString());
        }
        Lock lock = session.getLockInstance();
        Intrinsics.checkNotNull((Object)lock, (String)"null cannot be cast to non-null type java.util.concurrent.locks.ReentrantLock");
        if (!((ReentrantLock)lock).isLocked()) {
            boolean $i$a$-check-MockVaadin$createSession$52 = false;
            String $i$a$-check-MockVaadin$createSession$52 = session + " created from " + service + ": lock must be locked!";
            throw new IllegalStateException($i$a$-check-MockVaadin$createSession$52.toString());
        }
        VaadinSession.setCurrent((VaadinSession)session);
        strongRefSession.set(session);
        session.setBrowser(MockVaadinServletKt.WebBrowser((VaadinRequest)request));
        if (session.getBrowser().getBrowserApplication() == null) {
            boolean bl2 = false;
            String string2 = "The WebBrowser has not been mocked properly";
            throw new IllegalStateException(string2.toString());
        }
        VaadinServletResponse response = MockVaadinServletKt.createVaadinServletResponse(new MockResponse(), (VaadinService)service);
        strongRefRes.set((VaadinResponse)response);
        CurrentInstance.set(VaadinResponse.class, (Object)response);
        MockVaadinKt.access$fireSessionInitListeners((VaadinService)service, new SessionInitEvent((VaadinService)service, session, (VaadinRequest)request));
        this.createUI$vaadin_testbench_unit_shared(uiFactory, session);
    }

    public final void createUI$vaadin_testbench_unit_shared(@NotNull UIFactory uiFactory, @NotNull VaadinSession session) {
        Field field;
        Intrinsics.checkNotNullParameter((Object)uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        VaadinRequest vaadinRequest = VaadinRequest.getCurrent();
        if (vaadinRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        VaadinRequest request = vaadinRequest;
        UI ui = (UI)uiFactory.invoke();
        if (!(ui.getSession() == null)) {
            boolean $i$a$-require-MockVaadin$createUI$22 = false;
            String $i$a$-require-MockVaadin$createUI$22 = "uiFactory produced UI " + ui + " which is already attached to a Session, yet we expect the UI to be a fresh new instance, not yet attached to a Session, so that the tests are able to always start with a fresh UI with a pre-known state. Perhaps you're using Spring which reuses a scoped instance of the UI?";
            throw new IllegalArgumentException($i$a$-require-MockVaadin$createUI$22.toString());
        }
        Field $this$createUI_u24lambda_u241 = field = UI.class.getDeclaredField("page");
        boolean bl = false;
        $this$createUI_u24lambda_u241.setAccessible(true);
        $this$createUI_u24lambda_u241.set(ui, (Object)new MockPage(ui, uiFactory, session));
        ui.getInternals().setSession(session);
        UI.setCurrent((UI)ui);
        ui.doInit(request, 1, "ROOT");
        strongRefUI.set(ui);
        session.addUI(ui);
        session.getService().fireUIInitListeners(ui);
        if (lastNavigation.get() != null) {
            Router router = UI.getCurrent().getInternals().getRouter();
            UI uI = UI.getCurrent();
            Location location = lastNavigation.get();
            Intrinsics.checkNotNull((Object)location);
            router.navigate(uI, location, NavigationTrigger.PROGRAMMATIC);
            lastNavigation.remove();
        } else if (UI.getCurrent().getInternals().getRouter().getRegistry().getNavigationTarget("").isPresent()) {
            UI.getCurrent().navigate("");
        }
        ui.getPushConfiguration().setPushMode(PushMode.AUTOMATIC);
    }

    @JvmStatic
    public static final void clientRoundtrip() {
        if (VaadinSession.getCurrent() == null) {
            boolean bl = false;
            String string = "No VaadinSession";
            throw new IllegalStateException(string.toString());
        }
        MockVaadin.runUIQueue$default(false, null, 3, null);
        UI.getCurrent().getInternals().getStateTree().runExecutionsBeforeClientResponse();
        TestingLifecycleHookKt.cleanupDialogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void runUIQueue(boolean propagateExceptionToHandler, @NotNull VaadinSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List errors = new ArrayList();
        ErrorHandler oldErrorHandler = session.getErrorHandler();
        if (oldErrorHandler == null || oldErrorHandler instanceof DefaultErrorHandler || !propagateExceptionToHandler) {
            session.setErrorHandler(arg_0 -> MockVaadin.runUIQueue$lambda$0(errors, arg_0));
        }
        try {
            Lock lock = session.getLockInstance();
            Intrinsics.checkNotNull((Object)lock, (String)"null cannot be cast to non-null type java.util.concurrent.locks.ReentrantLock");
            int lockCount = ((ReentrantLock)lock).getHoldCount();
            if (lockCount != 1) {
                throw new AssertionError((Object)("Expected 1 lock, actual " + lockCount));
            }
            session.unlock();
            session.lock();
        }
        finally {
            session.setErrorHandler(oldErrorHandler);
        }
        if (!((Collection)errors).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)errors, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)errors.get(0)), (Throwable)it);
            }
            throw (Throwable)errors.get(0);
        }
    }

    public static /* synthetic */ void runUIQueue$default(boolean bl, VaadinSession vaadinSession, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            VaadinSession vaadinSession2 = VaadinSession.getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)vaadinSession2, (String)"getCurrent(...)");
            vaadinSession = vaadinSession2;
        }
        MockVaadin.runUIQueue(bl, vaadinSession);
    }

    @JvmStatic
    public static final void afterSessionClose(@NotNull VaadinSession session, @NotNull UIFactory uiFactory) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)uiFactory, (String)"uiFactory");
        if (!currentlyClosingSession.get().booleanValue()) {
            MockHttpSession mockSession = UtilsKt.getMock(session);
            INSTANCE.clearVaadinInstances(true);
            mockSession.destroy();
            INSTANCE.createSession(mockSession.getServletContext(), uiFactory);
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull Routes routes, @NotNull UIFactory uiFactory) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        Intrinsics.checkNotNullParameter((Object)uiFactory, (String)"uiFactory");
        MockVaadin.setup$default(routes, uiFactory, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull Routes routes) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        MockVaadin.setup$default(routes, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup() {
        MockVaadin.setup$default(null, null, null, 7, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void runUIQueue(boolean propagateExceptionToHandler) {
        MockVaadin.runUIQueue$default(propagateExceptionToHandler, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void runUIQueue() {
        MockVaadin.runUIQueue$default(false, null, 3, null);
    }

    private static final UI setup$lambda$0() {
        return new MockedUI();
    }

    private static final UI setup$lambda$1() {
        return new MockedUI();
    }

    private static final MockRequest mockRequestFactory$lambda$0(MockHttpSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MockRequest(it);
    }

    private static final void runUIQueue$lambda$0(List $errors, ErrorEvent it) {
        Throwable throwable = it.getThrowable();
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getThrowable(...)");
        Throwable t = throwable;
        if (!(t instanceof ExecutionException)) {
            t = new ExecutionException(t.getMessage(), t);
        }
        $errors.add(t);
    }
}

