/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.sidenav.SideNav;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.List;

@Tests(value={SideNav.class})
public class SideNavTester<T extends SideNav>
extends ComponentTester<T> {
    public SideNavTester(T component) {
        super(component);
    }

    public void clickItem(String topLevelLabel, String ... nestedItemLabels) {
        this.doClickItem(false, topLevelLabel, nestedItemLabels);
    }

    public void expandAndClickItem(String topLevelLabel, String ... nestedItemLabels) {
        this.doClickItem(true, topLevelLabel, nestedItemLabels);
    }

    @Override
    public void click() {
        this.ensureComponentIsUsable();
        if (((SideNav)this.getComponent()).isCollapsible()) {
            ((SideNav)this.getComponent()).setExpanded(!((SideNav)this.getComponent()).isExpanded());
        }
    }

    public void toggleItem(String topLevelLabel, String ... nestedItemLabels) {
        this.doToggleItem(false, topLevelLabel, nestedItemLabels);
    }

    public void toggle() {
        this.ensureComponentIsUsable();
        if (!((SideNav)this.getComponent()).isCollapsible()) {
            throw new IllegalStateException("Toggle button cannot be clicked because SideNav is not collapsible");
        }
        ((SideNav)this.getComponent()).setExpanded(!((SideNav)this.getComponent()).isExpanded());
    }

    private void doToggleItem(boolean expandNodes, String topLevelLabel, String ... nestedItemLabels) {
        this.ensureComponentIsUsable();
        SideNavItem navItem = this.findSideNavItemByPath(expandNodes, topLevelLabel, nestedItemLabels);
        if (navItem.getItems().isEmpty()) {
            throw new IllegalStateException("Toggle button cannot be clicked because the SideNav item has no children");
        }
        navItem.setExpanded(!navItem.isExpanded());
    }

    private void doClickItem(boolean expandNodes, String topLevelLabel, String ... nestedItemLabels) {
        this.ensureComponentIsUsable();
        SideNavItem navItem = this.findSideNavItemByPath(expandNodes, topLevelLabel, nestedItemLabels);
        if (navItem.getPath() != null) {
            UI.getCurrent().navigate(navItem.getPath());
        } else {
            navItem.setExpanded(!navItem.isExpanded());
        }
    }

    private SideNavItem findSideNavItemByPath(boolean expandNodes, String topLevelLabel, String ... nestedItemLabels) {
        SideNavItem navItem = this.findSideNavItem(((SideNav)this.getComponent()).getItems(), topLevelLabel, null);
        if (nestedItemLabels.length > 0) {
            String path = topLevelLabel + " / " + String.join((CharSequence)" / ", nestedItemLabels);
            for (String label : nestedItemLabels) {
                if (expandNodes) {
                    navItem.setExpanded(true);
                }
                if (!navItem.isExpanded()) {
                    throw new IllegalStateException("Cannot find SideNav item with label '" + label + "' on path '" + path + "' because parent item '" + navItem.getLabel() + "' is collapsed.");
                }
                List children = navItem.getItems();
                if (children.isEmpty()) {
                    throw new IllegalArgumentException("SideNav item with label " + navItem.getLabel() + " has no children. Make sure that the path is correct: " + path);
                }
                navItem = this.findSideNavItem(children, label, path);
            }
        }
        return navItem;
    }

    private SideNavItem findSideNavItem(List<SideNavItem> items, String label, String fullPath) {
        List<SideNavItem> navItems = items.stream().filter(item -> label.equals(item.getLabel())).toList();
        if (navItems.isEmpty()) {
            throw new IllegalArgumentException("Cannot find SideNav item '" + label + "'" + (String)(fullPath != null ? " on path " + fullPath : ""));
        }
        if (navItems.size() > 1) {
            throw new IllegalStateException("Found " + navItems.size() + " items with label '" + label + "'" + (String)(fullPath != null ? " on path " + fullPath : ""));
        }
        SideNavItem navItem = navItems.get(0);
        SideNavTester.ensureComponentIsUsable((Component)navItem, x$0 -> ComponentTester.isUsable(x$0));
        return navItem;
    }
}

