/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.testbench.unit.internal.BasicUtilsKt;
import com.vaadin.testbench.unit.internal.ComponentUtilsKt;
import com.vaadin.testbench.unit.internal.PrettyPrintTree;
import com.vaadin.testbench.unit.internal.UtilsKt;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\b\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"P\u0010\n\u001a8\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\" \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"prettyPrintUseAscii", "", "getPrettyPrintUseAscii", "()Z", "setPrettyPrintUseAscii", "(Z)V", "toPrettyTree", "", "Lcom/vaadin/flow/component/Component;", "toPrettyString", "prettyStringHook", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "component", "Ljava/util/LinkedList;", "list", "", "getPrettyStringHook", "()Lkotlin/jvm/functions/Function2;", "setPrettyStringHook", "(Lkotlin/jvm/functions/Function2;)V", "dontDumpAttributes", "", "getDontDumpAttributes", "()Ljava/util/Set;", "setDontDumpAttributes", "(Ljava/util/Set;)V", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nPrettyPrintTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettyPrintTree.kt\ncom/vaadin/testbench/unit/internal/PrettyPrintTreeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
public final class PrettyPrintTreeKt {
    private static boolean prettyPrintUseAscii;
    @NotNull
    private static Function2<? super Component, ? super LinkedList<String>, Unit> prettyStringHook;
    @NotNull
    private static Set<String> dontDumpAttributes;

    public static final boolean getPrettyPrintUseAscii() {
        return prettyPrintUseAscii;
    }

    public static final void setPrettyPrintUseAscii(boolean bl) {
        prettyPrintUseAscii = bl;
    }

    @NotNull
    public static final String toPrettyTree(@NotNull Component $this$toPrettyTree) {
        Intrinsics.checkNotNullParameter((Object)$this$toPrettyTree, (String)"<this>");
        return PrettyPrintTree.Companion.ofVaadin($this$toPrettyTree).print();
    }

    @NotNull
    public static final String toPrettyString(@NotNull Component $this$toPrettyString) {
        CharSequence outerHtml;
        Object object;
        KCallable hrefCallable;
        Object object2;
        KCallable functionOrProperty;
        Iterable iterable;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$toPrettyString, (String)"<this>");
        LinkedList<String> list = new LinkedList<String>();
        if ($this$toPrettyString.getId().isPresent()) {
            list.add('#' + (String)$this$toPrettyString.getId().get());
        }
        if (!BasicUtilsKt.get_isVisible($this$toPrettyString)) {
            list.add("INVIS");
        }
        if ($this$toPrettyString instanceof HasValue && ((HasValue)$this$toPrettyString).isReadOnly()) {
            list.add("RO");
        }
        if (!$this$toPrettyString.getElement().isEnabled()) {
            list.add("DISABLED");
        }
        if (!StringsKt.isBlank((CharSequence)ComponentUtilsKt.getLabel($this$toPrettyString))) {
            list.add("label='" + ComponentUtilsKt.getLabel($this$toPrettyString) + '\'');
        }
        if (!Intrinsics.areEqual((Object)ComponentUtilsKt.getLabel($this$toPrettyString), (Object)ComponentUtilsKt.getCaption($this$toPrettyString)) && !StringsKt.isBlank((CharSequence)ComponentUtilsKt.getCaption($this$toPrettyString))) {
            list.add("caption='" + ComponentUtilsKt.getCaption($this$toPrettyString) + '\'');
        }
        if (!((charSequence = (CharSequence)BasicUtilsKt.get_text($this$toPrettyString)) == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)BasicUtilsKt.get_text($this$toPrettyString), (Object)ComponentUtilsKt.getCaption($this$toPrettyString))) {
            list.add("text='" + BasicUtilsKt.get_text($this$toPrettyString) + '\'');
        }
        if ($this$toPrettyString instanceof HasValue) {
            list.add("value='" + ((HasValue)$this$toPrettyString).getValue() + '\'');
        }
        if ($this$toPrettyString instanceof HasValidation) {
            if (((HasValidation)$this$toPrettyString).isInvalid()) {
                list.add("INVALID");
            }
            if (!((charSequence = (CharSequence)((HasValidation)$this$toPrettyString).getErrorMessage()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                list.add("errorMessage='" + ((HasValidation)$this$toPrettyString).getErrorMessage() + '\'');
            }
        }
        Object[] objectArray = new String[]{"value", "invalid", "openOn", "label", "errorMessage", "innerHTML", "i18n", "error", "stackTrace"};
        List ignoredAttr = CollectionsKt.mutableListOf((Object[])objectArray);
        $this$toPrettyString.getElement().getPropertyNames().forEach(arg_0 -> PrettyPrintTreeKt.toPrettyString$lambda$1(arg_0 -> PrettyPrintTreeKt.toPrettyString$lambda$0($this$toPrettyString, ignoredAttr, list, arg_0), arg_0));
        try {
            Object v0;
            block24: {
                iterable = JvmClassMappingKt.getKotlinClass($this$toPrettyString.getClass()).getMembers();
                for (Object t : iterable) {
                    KCallable it = (KCallable)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"href")) continue;
                    v0 = t;
                    break block24;
                }
                v0 = null;
            }
            KCallable kCallable = functionOrProperty = (KCallable)v0;
            if (kCallable != null) {
                KCallablesJvm.setAccessible((KCallable)kCallable, (boolean)true);
            }
        }
        catch (TypeNotPresentException t) {
            Method method;
            Object object3;
            block25: {
                Method[] methodArray = $this$toPrettyString.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                for (Object object4 : (Object[])methodArray) {
                    Method it = (Method)object4;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"href")) continue;
                    object3 = object4;
                    break block25;
                }
                object3 = null;
            }
            Method method2 = method = (Method)object3;
            functionOrProperty = (KCallable)(method2 != null ? ReflectJvmMapping.getKotlinFunction((Method)method2) : null);
        }
        if ((object2 = (hrefCallable = functionOrProperty)) != null && (object2 = object2.call(object = new Object[]{$this$toPrettyString})) != null) {
            Object it = object2;
            boolean bl = false;
            list.add("href='" + it + '\'');
        }
        if ($this$toPrettyString instanceof Button && ((Button)$this$toPrettyString).getIcon() instanceof Icon) {
            StringBuilder stringBuilder = new StringBuilder().append("icon='");
            Component component = ((Button)$this$toPrettyString).getIcon();
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.vaadin.flow.component.icon.Icon");
            list.add(stringBuilder.append(((Icon)component).getElement().getAttribute("icon")).append('\'').toString());
        }
        if ($this$toPrettyString instanceof Html) {
            String string = ((Html)$this$toPrettyString).getElement().getOuterHTML();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOuterHTML(...)");
            object = ((Object)StringsKt.trim((CharSequence)string)).toString();
            iterable = new Regex("\\s+");
            String string2 = " ";
            outerHtml = iterable.replace((CharSequence)object, string2);
            list.add(UtilsKt.ellipsize$default(outerHtml, 100, null, 2, null));
        }
        if ($this$toPrettyString instanceof Grid && ((Grid)$this$toPrettyString).getBeanType() != null) {
            list.add('<' + ((Grid)$this$toPrettyString).getBeanType().getSimpleName() + '>');
        }
        if (ComponentUtilsKt.getDataProvider($this$toPrettyString) != null) {
            list.add("dataprovider='" + ComponentUtilsKt.getDataProvider($this$toPrettyString) + '\'');
        }
        $this$toPrettyString.getElement().getAttributeNames().filter(arg_0 -> PrettyPrintTreeKt.toPrettyString$lambda$6(PrettyPrintTreeKt::toPrettyString$lambda$5, arg_0)).sorted().forEach(arg_0 -> PrettyPrintTreeKt.toPrettyString$lambda$8(arg_0 -> PrettyPrintTreeKt.toPrettyString$lambda$7($this$toPrettyString, list, arg_0), arg_0));
        if (!($this$toPrettyString instanceof Html) && !((outerHtml = (CharSequence)$this$toPrettyString.getElement().getProperty("innerHTML")) == null || StringsKt.isBlank((CharSequence)outerHtml))) {
            String string = $this$toPrettyString.getElement().getProperty("innerHTML");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            object = ((Object)StringsKt.trim((CharSequence)string)).toString();
            iterable = new Regex("\\s+");
            String string3 = " ";
            String innerHTML = iterable.replace((CharSequence)object, string3);
            list.add("innerHTML='" + innerHTML + '\'');
        }
        if (UtilsKt.hasCustomToString($this$toPrettyString.getClass())) {
            list.add($this$toPrettyString.toString());
        }
        prettyStringHook.invoke((Object)$this$toPrettyString, list);
        String string = $this$toPrettyString.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        String name = string;
        if (((CharSequence)name).length() == 0) {
            String string4 = $this$toPrettyString.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            name = string4;
        }
        return name + list;
    }

    @NotNull
    public static final Function2<Component, LinkedList<String>, Unit> getPrettyStringHook() {
        return prettyStringHook;
    }

    public static final void setPrettyStringHook(@NotNull Function2<? super Component, ? super LinkedList<String>, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        prettyStringHook = function2;
    }

    @NotNull
    public static final Set<String> getDontDumpAttributes() {
        return dontDumpAttributes;
    }

    public static final void setDontDumpAttributes(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        dontDumpAttributes = set;
    }

    private static final Unit toPrettyString$lambda$0(Component $this_toPrettyString, List $ignoredAttr, LinkedList $list, String it) {
        String propertyValue = $this_toPrettyString.getElement().getProperty(it);
        if (propertyValue != null && !$ignoredAttr.contains(it) && ((CharSequence)propertyValue).length() > 0) {
            Intrinsics.checkNotNull((Object)it);
            if (!StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null)) {
                $list.add(it + "='" + propertyValue + '\'');
            }
        }
        return Unit.INSTANCE;
    }

    private static final void toPrettyString$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean toPrettyString$lambda$5(String it) {
        return !dontDumpAttributes.contains(it);
    }

    private static final boolean toPrettyString$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit toPrettyString$lambda$7(Component $this_toPrettyString, LinkedList $list, String attributeName) {
        String value = $this_toPrettyString.getElement().getAttribute(attributeName);
        CharSequence charSequence = value;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $list.add('@' + attributeName + "='" + value + '\'');
        }
        return Unit.INSTANCE;
    }

    private static final void toPrettyString$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit prettyStringHook$lambda$0(Component component, LinkedList linkedList) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)linkedList, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    static {
        prettyStringHook = PrettyPrintTreeKt::prettyStringHook$lambda$0;
        Object[] objectArray = new String[]{"disabled", "id", "href"};
        dontDumpAttributes = SetsKt.mutableSetOf((Object[])objectArray);
    }
}

