/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.component.combobox.ComboBoxDataController;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import com.vaadin.testbench.unit.internal.BasicUtilsKt;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tests(fqn={"com.vaadin.flow.component.combobox.ComboBox"})
@Deprecated(forRemoval=true, since="10.1")
public class ComboBoxTester<T extends ComboBox<Y>, Y>
extends ComponentTester<T> {
    public ComboBoxTester(T component) {
        super(component);
    }

    public void setFilter(String filter) {
        this.ensureComponentIsUsable();
        try {
            Field dataControllerField = this.getField(ComboBoxBase.class, "dataController");
            ComboBoxDataController dataController = (ComboBoxDataController)dataControllerField.get(this.getComponent());
            Field filterSlot = this.getField(ComboBoxDataController.class, "filterSlot");
            ((SerializableConsumer)filterSlot.get(dataController)).accept((Object)filter);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void selectItem(String selection) {
        if (selection == null) {
            this.setValueAsUser(null);
            return;
        }
        List<Y> suggestionItems = this.getSuggestionItems();
        ItemLabelGenerator itemLabelGenerator = ((ComboBox)this.getComponent()).getItemLabelGenerator();
        List filtered = suggestionItems.stream().filter(item -> selection.equals(itemLabelGenerator.apply(item))).collect(Collectors.toList());
        if (filtered.size() != 1) {
            throw new IllegalArgumentException("No item found for '" + selection + "'");
        }
        this.setValueAsUser(filtered.get(0));
    }

    public Y getSelected() {
        return (Y)((ComboBox)this.getComponent()).getValue();
    }

    public List<String> getSuggestions() {
        List<Y> suggestionItems = this.getSuggestionItems();
        ItemLabelGenerator itemLabelGenerator = ((ComboBox)this.getComponent()).getItemLabelGenerator();
        return suggestionItems.stream().map(item -> itemLabelGenerator.apply(item)).collect(Collectors.toList());
    }

    public List<Y> getSuggestionItems() {
        try {
            Field dataControllerField = this.getField(ComboBoxBase.class, "dataController");
            ComboBoxDataController dataController = (ComboBoxDataController)dataControllerField.get(this.getComponent());
            Field dataCommunicatorField = this.getField(ComboBoxDataController.class, "dataCommunicator");
            DataCommunicator dataCommunicator = (DataCommunicator)dataCommunicatorField.get(dataController);
            Method fetchFromProvider = this.getMethod(DataCommunicator.class, "fetchFromProvider", Integer.TYPE, Integer.TYPE);
            List result = ((Stream)fetchFromProvider.invoke((Object)dataCommunicator, 0, BasicUtilsKt.get_saneFetchLimit())).collect(Collectors.toList());
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

