/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.textfield.BigDecimalField;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.function.Consumer;

@Tests(value={TextField.class, PasswordField.class, EmailField.class, BigDecimalField.class})
@Deprecated(forRemoval=true, since="10.1")
public class TextFieldTester<T extends TextFieldBase<T, V>, V>
extends ComponentTester<T> {
    public TextFieldTester(T component) {
        super(component);
    }

    public void setValue(V value) {
        this.ensureComponentIsUsable();
        if (value == null && ((TextFieldBase)this.getComponent()).getEmptyValue() != null) {
            throw new IllegalArgumentException("Field doesn't allow null values");
        }
        this.setValueAsUser(value);
    }

    public void clear() {
        this.ensureComponentIsUsable();
        if (!(this.getComponent() instanceof HasClearButton) || !((HasClearButton)this.getComponent()).isClearButtonVisible()) {
            throw new IllegalStateException("Clear button is not visible");
        }
        this.setValue(((TextFieldBase)this.getComponent()).getEmptyValue());
    }

    private boolean hasValidation() {
        return this.getValidationSupport() != null;
    }

    private TextFieldValidationSupport getValidationSupport() {
        try {
            return (TextFieldValidationSupport)this.getField("validationSupport").get(this.getComponent());
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((TextFieldBase)this.getComponent()).isReadOnly();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((TextFieldBase)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
    }
}

