/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabSheet;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.Objects;
import java.util.stream.Stream;

@Tests(value={TabSheet.class})
@Deprecated(forRemoval=true, since="10.1")
public class TabSheetTester<T extends TabSheet>
extends ComponentTester<T> {
    public TabSheetTester(T component) {
        super(component);
    }

    public void select(String label) {
        Objects.requireNonNull(label, "label must not be null");
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(label);
        this.doSelectTab(tab, "Tab with label '" + label + "' cannot be selected because it is not usable");
    }

    public void select(int index) {
        this.ensureComponentIsUsable();
        if (index >= 0) {
            this.doSelectTab(this.findTab(index), "Tab at index " + index + " cannot be selected because it is not usable");
        } else {
            ((TabSheet)this.getComponent()).setSelectedTab(null);
        }
    }

    public boolean isSelected(String label) {
        this.ensureComponentIsUsable();
        return this.findTab(label).isSelected();
    }

    public boolean isSelected(int index) {
        this.ensureComponentIsUsable();
        return this.findTab(index).isSelected();
    }

    public Tab getTab(String label) {
        Objects.requireNonNull(label, "label must not be null");
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(label);
        if (tab != null && !tab.isVisible()) {
            throw new IllegalStateException("Tab with label '" + label + "' cannot be selected because it is not usable");
        }
        return tab;
    }

    public Tab getTab(int index) {
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(index);
        if (tab != null && !tab.isVisible()) {
            throw new IllegalStateException("Tab at index " + index + " cannot be selected because it is not usable");
        }
        return tab;
    }

    public <E extends Component> E getTabContent(String label) {
        Objects.requireNonNull(label, "label must not be null");
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(label);
        if (tab != null && !tab.isVisible()) {
            throw new IllegalStateException("Tab with label '" + label + "' cannot be selected because it is not usable");
        }
        return (E)((TabSheet)this.getComponent()).getComponent(tab);
    }

    public <E extends Component> E getTabContent(int index) {
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(index);
        if (tab != null && !tab.isVisible()) {
            throw new IllegalStateException("Tab at index " + index + " cannot be selected because it is not usable");
        }
        return (E)((TabSheet)this.getComponent()).getComponent(tab);
    }

    private Tab findTab(String label) {
        return ((TabSheet)this.getComponent()).getChildren().filter(Tabs.class::isInstance).flatMap(tabs -> tabs.getChildren().filter(Tab.class::isInstance)).map(Tab.class::cast).filter(t -> label.equals(t.getLabel())).findFirst().orElseThrow(() -> new IllegalArgumentException("Tab with label '" + label + "' does not exist"));
    }

    private Tab findTab(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The 'index' argument should be greater than or equal to 0. It was: " + index);
        }
        Tabs tabs = ((TabSheet)this.getComponent()).getChildren().filter(Tabs.class::isInstance).map(Tabs.class::cast).findFirst().orElseThrow();
        return (Tab)((Stream)tabs.getChildren().sequential()).filter(Component::isVisible).skip(index).findFirst().orElseThrow(() -> new IllegalArgumentException("The 'index' argument should not be greater than or equals to the number of visible children tabs. It was: " + index));
    }

    private void doSelectTab(Tab tab, String errorMessage) {
        if (!(tab == null || tab.isEnabled() && tab.isVisible())) {
            throw new IllegalStateException(errorMessage);
        }
        ((TabSheet)this.getComponent()).setSelectedTab(tab);
    }
}

