/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.AbstractFieldSupport;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.testbench.unit.BaseUIUnitTest;
import com.vaadin.testbench.unit.Clickable;
import com.vaadin.testbench.unit.ComponentQuery;
import com.vaadin.testbench.unit.internal.PrettyPrintTreeKt;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@Deprecated(forRemoval=true, since="10.1")
public class ComponentTester<T extends Component>
implements Clickable<T> {
    private final T component;

    public ComponentTester(T component) {
        this.component = component;
        if (!this.isUsable()) {
            LoggerFactory.getLogger((String)"Test wrap").debug("Wrapped component '{}' that is not interactable", (Object)component.getClass().getSimpleName());
        }
    }

    @Override
    public T getComponent() {
        return this.component;
    }

    public boolean isUsable() {
        return ComponentTester.isUsable(this.getComponent());
    }

    protected static boolean isUsable(Component component) {
        return component.getElement().isEnabled() && component.isAttached() && ComponentTester.isEffectivelyVisible(component) && !component.getElement().getNode().isInert();
    }

    private static boolean isEffectivelyVisible(Component component) {
        return component.isVisible() && (!component.getParent().isPresent() || ComponentTester.isEffectivelyVisible((Component)component.getParent().get()));
    }

    public void setModal(boolean modal) {
        UI.getCurrent().setChildComponentModal(this.component, modal);
    }

    public <R extends Component> ComponentQuery<R> find(Class<R> componentType) {
        return BaseUIUnitTest.internalQuery(componentType).from((Component)this.component);
    }

    @Override
    public final void ensureComponentIsUsable() {
        ComponentTester.ensureComponentIsUsable(this.component, unused -> this.isUsable());
    }

    protected static void ensureComponentIsUsable(Component component, Predicate<Component> usableTest) {
        if (!usableTest.test(component)) {
            StringBuilder message = new StringBuilder(PrettyPrintTreeKt.toPrettyString(component) + " is not usable");
            Stream.Builder reasons = Stream.builder();
            ComponentTester.notUsableReasons(component, reasons::add);
            message.append(reasons.build().collect(Collectors.joining(", ", " because it is ", ".")));
            throw new IllegalStateException(message.toString());
        }
    }

    protected void notUsableReasons(Consumer<String> collector) {
        ComponentTester.notUsableReasons(this.component, collector);
    }

    protected static void notUsableReasons(Component component, Consumer<String> collector) {
        if (!component.getElement().isEnabled()) {
            collector.accept("not enabled");
        }
        if (!component.isAttached()) {
            collector.accept("not attached");
        }
        if (!component.isVisible()) {
            collector.accept("not visible");
        } else if (!ComponentTester.isEffectivelyVisible(component)) {
            collector.accept("part of a not visible subtree");
        }
        if (component.getElement().getNode().isInert()) {
            collector.accept("behind a modality curtain");
        }
    }

    protected void ensureVisible() {
        ComponentTester.ensureVisible(this.getComponent());
    }

    protected static void ensureVisible(Component component) {
        if (!component.isVisible() || !component.isAttached()) {
            throw new IllegalStateException(PrettyPrintTreeKt.toPrettyString(component) + " is not visible!");
        }
    }

    protected void roundTrip() {
        BaseUIUnitTest.roundTrip();
    }

    protected Field getField(String fieldName) {
        return this.getField(this.getComponent().getClass(), fieldName);
    }

    protected Field getField(Class target, String fieldName) {
        try {
            Field field = target.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Method getMethod(String methodName, Class<?> ... parameterTypes) {
        return this.getMethod(this.getComponent().getClass(), methodName, parameterTypes);
    }

    protected Method getMethod(Class target, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = target.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected void fireDomEvent(String eventType) {
        this.fireDomEvent(eventType, JacksonUtils.createObjectNode());
    }

    protected void fireDomEvent(String eventType, ObjectNode eventData) {
        DomEvent event = new DomEvent(this.getComponent().getElement(), eventType, (JsonNode)eventData);
        this.fireDomEvent(event);
    }

    protected void fireDomEvent(DomEvent event) {
        ((ElementListenerMap)event.getSource().getNode().getFeature(ElementListenerMap.class)).fireEvent(event);
    }

    protected <R extends Component> Optional<R> findByQuery(Class<R> componentType, Consumer<ComponentQuery<R>> queryBuilder) {
        List<R> result = this.findAllByQuery(componentType, queryBuilder);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() > 1) {
            StringBuilder message = new StringBuilder("Expecting the query to produce at most one result, but got ").append(result.size()).append(": ");
            message.append(result.stream().map(PrettyPrintTreeKt::toPrettyString).collect(Collectors.joining(", ")));
            throw new IllegalArgumentException(message.toString());
        }
        return Optional.of((Component)result.get(0));
    }

    protected <R extends Component> List<R> findAllByQuery(Class<R> componentType, Consumer<ComponentQuery<R>> queryBuilder) {
        ComponentQuery<R> query = BaseUIUnitTest.internalQuery(componentType).from((Component)this.component);
        queryBuilder.accept(query);
        query.from((Component)this.component);
        return query.all();
    }

    private <V> AbstractFieldSupport<?, V> getFieldSupport() {
        try {
            Field javaField = AbstractField.class.getDeclaredField("fieldSupport");
            javaField.setAccessible(true);
            return (AbstractFieldSupport)javaField.get(this.component);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected <V> void setValueAsUser(V value) {
        if (this.component instanceof AbstractField) {
            AbstractFieldSupport<?, V> fs = this.getFieldSupport();
            try {
                Method m = AbstractFieldSupport.class.getDeclaredMethod("setValue", Object.class, Boolean.TYPE, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(fs, value, false, true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        throw new IllegalArgumentException("Parameter component: invalid value " + String.valueOf(this.component) + ": unsupported type of HasValue: " + String.valueOf(this.component.getClass()));
    }
}

