/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit;

import com.vaadin.flow.component.Component;
import com.vaadin.testbench.unit.ElementConditions;
import com.vaadin.testbench.unit.internal.LocatorKt;
import com.vaadin.testbench.unit.internal.SearchSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.ranges.IntRange;

@Deprecated(forRemoval=true, since="10.1")
public class ComponentQuery<T extends Component> {
    private final Class<T> componentType;
    private final LocatorSpec<T> locatorSpec = new LocatorSpec();
    private Component context;

    public ComponentQuery(Class<T> componentType) {
        this.componentType = Objects.requireNonNull(componentType, "Component type must not be null");
    }

    public <V> ComponentQuery<T> withPropertyValue(Function<T, V> getter, V expectedValue) {
        Objects.requireNonNull(getter, "getter function must not be null");
        this.locatorSpec.predicates.add(c -> Objects.equals(getter.apply(c), expectedValue));
        return this;
    }

    public <V> ComponentQuery<T> withValue(V expectedValue) {
        this.locatorSpec.value = expectedValue;
        return this;
    }

    public ComponentQuery<T> withId(String id) {
        this.locatorSpec.id = id;
        this.locatorSpec.count = new IntRange(0, 1);
        return this;
    }

    public ComponentQuery<T> withCondition(Predicate<T> condition) {
        Objects.requireNonNull(condition, "condition must not be null");
        this.locatorSpec.predicates.add(condition);
        return this;
    }

    public ComponentQuery<T> withClassName(String ... className) {
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (Stream.of(className).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("class names must not be null");
        }
        if (className.length > 0) {
            this.locatorSpec.classes.addAll(List.of(className));
        }
        return this;
    }

    public ComponentQuery<T> withoutClassName(String ... className) {
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (Stream.of(className).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("class names must not be null");
        }
        if (className.length > 0) {
            this.locatorSpec.withoutClasses.addAll(List.of(className));
        }
        return this;
    }

    public ComponentQuery<T> withTheme(String theme) {
        this.locatorSpec.themes = this.locatorSpec.themes == null || this.locatorSpec.themes.isEmpty() ? theme : this.locatorSpec.themes + " " + theme;
        return this;
    }

    public ComponentQuery<T> withoutTheme(String theme) {
        this.locatorSpec.withoutThemes = this.locatorSpec.withoutThemes == null || this.locatorSpec.withoutThemes.isEmpty() ? theme : this.locatorSpec.withoutThemes + " " + theme;
        return this;
    }

    public ComponentQuery<T> withCaption(String caption) {
        this.locatorSpec.caption = caption;
        this.locatorSpec.captionExactMatch = true;
        return this;
    }

    public ComponentQuery<T> withCaptionContaining(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.locatorSpec.caption = text;
        this.locatorSpec.captionExactMatch = false;
        return this;
    }

    public ComponentQuery<T> withText(String text) {
        this.locatorSpec.text = text;
        this.locatorSpec.textExactMatch = true;
        return this;
    }

    public ComponentQuery<T> withTextContaining(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.locatorSpec.text = text;
        this.locatorSpec.textExactMatch = false;
        return this;
    }

    public ComponentQuery<T> withResultsSize(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater or equal than zero, but was " + count);
        }
        this.locatorSpec.count = new IntRange(count, count);
        return this;
    }

    public ComponentQuery<T> withResultsSize(int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("min must be greater or equal than zero, but was " + min);
        }
        if (max < 0) {
            throw new IllegalArgumentException("max must be greater or equal than zero, but was " + max);
        }
        if (min > max) {
            throw new IllegalArgumentException("max must be greater or equal than min, but was min=" + min + ", max=" + max);
        }
        this.locatorSpec.count = new IntRange(min, max);
        return this;
    }

    public ComponentQuery<T> withMinResults(int min) {
        return this.withResultsSize(min, this.locatorSpec.count.getEndInclusive());
    }

    public ComponentQuery<T> withMaxResults(int max) {
        return this.withResultsSize(this.locatorSpec.count.getStart(), max);
    }

    public ComponentQuery<T> withAttribute(String attribute) {
        this.locatorSpec.predicates.add(ElementConditions.hasAttribute(attribute));
        return this;
    }

    public ComponentQuery<T> withAttribute(String attribute, String value) {
        this.locatorSpec.predicates.add(ElementConditions.hasAttribute(attribute, value));
        return this;
    }

    public ComponentQuery<T> withoutAttribute(String attribute) {
        this.locatorSpec.predicates.add(ElementConditions.hasNotAttribute(attribute));
        return this;
    }

    public ComponentQuery<T> withoutAttribute(String attribute, String value) {
        this.locatorSpec.predicates.add(ElementConditions.hasNotAttribute(attribute, value));
        return this;
    }

    public <E extends Component> ComponentQuery<E> thenOnFirst(Class<E> componentType) {
        return this.thenOn(1, componentType);
    }

    public <E extends Component> ComponentQuery<E> thenOn(int index, Class<E> componentType) {
        return new ComponentQuery<E>(componentType).from((Component)this.atIndex(index));
    }

    public T single() {
        return this.find();
    }

    @Deprecated(since="10.0", forRemoval=true)
    public T first() {
        return (T)((Component)this.all().stream().findFirst().orElseThrow(() -> new NoSuchElementException("Cannot find component for current query")));
    }

    public T last() {
        return (T)((Component)this.all().stream().reduce((first, second) -> second).orElseThrow(() -> new NoSuchElementException("Cannot find component for current query")));
    }

    public T atIndex(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException("Index must be greater than zero, but was " + index);
        }
        List<T> result = this.all();
        if (result.isEmpty()) {
            throw new NoSuchElementException("Cannot find component for current query");
        }
        int resultSize = result.size();
        if (index > resultSize) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + ". Current query produces " + resultSize + " results");
        }
        return (T)((Component)result.get(index - 1));
    }

    public T id(String id) {
        Objects.requireNonNull(id, "id must not be null");
        this.withId(id);
        this.locatorSpec.count = new IntRange(1, 1);
        return this.find();
    }

    public boolean exists() {
        return !this.all().isEmpty();
    }

    public List<T> all() {
        if (this.context != null) {
            return LocatorKt._find(this.context, this.componentType, this.locatorSpec::populate);
        }
        return LocatorKt._find(this.componentType, this.locatorSpec::populate);
    }

    public ComponentQuery<T> from(Component context) {
        this.context = context;
        return this;
    }

    protected T find() {
        this.locatorSpec.count = new IntRange(1, 1);
        try {
            if (this.context != null) {
                return LocatorKt._get(this.context, this.componentType, this.locatorSpec::populate);
            }
            return LocatorKt._get(this.componentType, this.locatorSpec::populate);
        }
        catch (AssertionError e) {
            throw new NoSuchElementException(((Throwable)((Object)e)).getMessage());
        }
    }

    private static class LocatorSpec<T extends Component> {
        String id;
        String caption;
        boolean captionExactMatch = false;
        String placeholder;
        String text;
        boolean textExactMatch = true;
        IntRange count = new IntRange(0, Integer.MAX_VALUE);
        Object value;
        final Set<String> classes = new HashSet<String>();
        final Set<String> withoutClasses = new HashSet<String>();
        String themes;
        String withoutThemes;
        List<Predicate<T>> predicates = new ArrayList<Predicate<T>>(0);

        private LocatorSpec() {
        }

        public Unit populate(SearchSpec<T> spec) {
            if (this.id != null) {
                spec.setId(this.id);
            }
            if (this.caption != null && this.captionExactMatch) {
                spec.setCaption(this.caption);
            } else if (this.caption != null) {
                spec.captionContains(this.caption);
            }
            if (this.placeholder != null) {
                spec.setPlaceholder(this.placeholder);
            }
            if (this.text != null && this.textExactMatch) {
                spec.setText(this.text);
            } else if (this.text != null) {
                spec.getPredicates().add(ElementConditions.containsText(this.text));
            }
            if (this.value != null) {
                spec.setValue(this.value);
            }
            if (!this.classes.isEmpty()) {
                spec.setClasses(String.join((CharSequence)" ", this.classes));
            }
            if (!this.withoutClasses.isEmpty()) {
                spec.setWithoutClasses(String.join((CharSequence)" ", this.withoutClasses));
            }
            if (this.themes != null) {
                spec.setThemes(this.themes);
            }
            if (this.withoutThemes != null) {
                spec.setWithoutThemes(this.withoutThemes);
            }
            spec.setCount(this.count);
            spec.getPredicates().addAll(this.predicates);
            return Unit.INSTANCE;
        }
    }
}

