/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxTester;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@Tests(fqn={"com.vaadin.flow.component.checkbox.CheckboxGroup"})
@Deprecated(forRemoval=true, since="10.1")
public class CheckboxGroupTester<T extends CheckboxGroup<V>, V>
extends ComponentTester<T> {
    public CheckboxGroupTester(T component) {
        super(component);
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !((CheckboxGroup)this.getComponent()).isReadOnly();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        super.notUsableReasons(collector);
        if (((CheckboxGroup)this.getComponent()).isReadOnly()) {
            collector.accept("read only");
        }
    }

    public void selectItem(String selection) {
        this.ensureComponentIsUsable();
        this.selectItems(List.of(selection));
    }

    public void selectItems(String ... selection) {
        this.ensureComponentIsUsable();
        this.selectItems(List.of(selection));
    }

    public void selectItems(Collection<String> selection) {
        this.ensureComponentIsUsable();
        this.updateSelection(selection, Collection::addAll);
    }

    public void selectAll() {
        this.ensureComponentIsUsable();
        this.setValueAsUser(this.getCheckboxes(child -> this.isUsableCheckbox((Checkbox)child, false)).map(this::getCheckboxValue).collect(Collectors.toSet()));
    }

    public void deselectItem(String selection) {
        this.ensureComponentIsUsable();
        this.deselectItems(List.of(selection));
    }

    public void deselectItems(String ... selection) {
        this.ensureComponentIsUsable();
        this.deselectItems(List.of(selection));
    }

    public void deselectItems(Collection<String> selection) {
        this.ensureComponentIsUsable();
        this.updateSelection(selection, Collection::removeAll);
    }

    public void deselectAll() {
        this.ensureComponentIsUsable();
        Set usableItems = this.getCheckboxes(child -> this.isUsableCheckbox((Checkbox)child, false)).map(this::getCheckboxValue).collect(Collectors.toSet());
        HashSet selectedItems = new HashSet((Collection)((CheckboxGroup)this.getComponent()).getValue());
        selectedItems.removeAll(usableItems);
        ((CheckboxGroup)this.getComponent()).setValue(selectedItems);
    }

    public Set<V> getSelected() {
        return (Set)((CheckboxGroup)this.getComponent()).getValue();
    }

    @NotNull
    private Stream<Checkbox> getCheckboxes(Predicate<Checkbox> filter) {
        return ((CheckboxGroup)this.getComponent()).getChildren().filter(Checkbox.class::isInstance).map(Checkbox.class::cast).filter(filter);
    }

    private V getCheckboxValue(Checkbox checkbox) {
        HasItemComponents.ItemComponent cast = (HasItemComponents.ItemComponent)checkbox;
        return (V)cast.getItem();
    }

    private boolean isUsableCheckbox(Checkbox checkbox, boolean throwIfNotUsable) {
        boolean usable = new CheckboxTester<Checkbox>(checkbox).isUsable();
        if (!usable && throwIfNotUsable) {
            throw new IllegalStateException("Item " + checkbox.getLabel() + " is not usable");
        }
        return usable;
    }

    public void updateSelection(Collection<String> selection, BiConsumer<Collection<V>, Collection<V>> updater) {
        HashSet<String> uniqueItems = new HashSet<String>(selection);
        Map<String, Object> selectedItems = this.getCheckboxes(child -> uniqueItems.contains(child.getLabel())).filter(child -> this.isUsableCheckbox((Checkbox)child, true)).collect(Collectors.toMap(Checkbox::getLabel, this::getCheckboxValue));
        uniqueItems.removeAll(selectedItems.keySet());
        if (!uniqueItems.isEmpty()) {
            throw new IllegalArgumentException("Invalid Item string representation: " + String.valueOf(uniqueItems));
        }
        HashSet newValues = new HashSet((Collection)((CheckboxGroup)this.getComponent()).getValue());
        updater.accept(newValues, selectedItems.values());
        ((CheckboxGroup)this.getComponent()).setValue(Set.copyOf(newValues));
    }
}

