/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.routerlink;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.net.URI;
import java.util.Optional;

@Tests(value={RouterLink.class})
@Deprecated(forRemoval=true, since="10.1")
public class RouterLinkTester<T extends RouterLink>
extends ComponentTester<T> {
    public RouterLinkTester(T component) {
        super(component);
    }

    public String getHref() {
        this.ensureComponentIsUsable();
        return ((RouterLink)this.getComponent()).getHref();
    }

    public String getPath() {
        return URI.create(this.getHref()).getPath();
    }

    public QueryParameters getQueryParameters() {
        return QueryParameters.fromString((String)URI.create(this.getHref()).getQuery());
    }

    public Optional<Class<? extends Component>> getRoute() {
        return RouteConfiguration.forSessionScope().getRoute(this.getPath());
    }

    public HasElement navigate() {
        this.ensureComponentIsUsable();
        String path = this.getPath();
        if (this.getRoute().isEmpty()) {
            throw new IllegalStateException("Application route not found for path " + path);
        }
        UI.getCurrent().navigate(path, this.getQueryParameters());
        return (HasElement)UI.getCurrent().getInternals().getActiveRouterTargetsChain().get(0);
    }

    @Override
    public void click() {
        this.navigate();
    }
}

