/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.mocks;

import com.vaadin.testbench.unit.mocks.MockHttpEnvironmentKt;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Replace the vaadin-testbench-unit dependency with browserless-test-junit6 and use the corresponding class from the com.vaadin.browserless package instead. This class will be removed in a future version.")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0004H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0016J\u001a\u0010$\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0004H\u0016J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0001J\b\u0010)\u001a\u00020\u0018H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020\u0018H\u0002J\b\u0010,\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006."}, d2={"Lcom/vaadin/testbench/unit/mocks/MockHttpSession;", "Ljakarta/servlet/http/HttpSession;", "Ljava/io/Serializable;", "sessionId", "", "servletContext", "Ljakarta/servlet/ServletContext;", "creationTime", "", "maxInactiveInterval", "", "<init>", "(Ljava/lang/String;Ljakarta/servlet/ServletContext;JI)V", "session", "(Ljakarta/servlet/http/HttpSession;)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "valid", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isValid", "", "()Z", "destroy", "", "getCreationTime", "getId", "getLastAccessedTime", "getServletContext", "setMaxInactiveInterval", "interval", "getMaxInactiveInterval", "getAttribute", "name", "getAttributeNames", "Ljava/util/Enumeration;", "setAttribute", "value", "removeAttribute", "copyAttributes", "httpSession", "invalidate", "isNew", "checkValid", "toString", "Companion", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nMockHttpSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockHttpSession.kt\ncom/vaadin/testbench/unit/mocks/MockHttpSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1869#2,2:124\n*S KotlinDebug\n*F\n+ 1 MockHttpSession.kt\ncom/vaadin/testbench/unit/mocks/MockHttpSession\n*L\n87#1:124,2\n*E\n"})
public class MockHttpSession
implements HttpSession,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final ServletContext servletContext;
    private final long creationTime;
    private int maxInactiveInterval;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    @NotNull
    private final AtomicBoolean valid;
    @NotNull
    private static final AtomicInteger sessionIdGenerator = new AtomicInteger();

    public MockHttpSession(@NotNull String sessionId, @NotNull ServletContext servletContext, long creationTime, int maxInactiveInterval) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        this.sessionId = sessionId;
        this.servletContext = servletContext;
        this.creationTime = creationTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.attributes = new ConcurrentHashMap();
        this.valid = new AtomicBoolean(true);
    }

    public final boolean isValid() {
        return this.valid.get();
    }

    public MockHttpSession(@NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ServletContext servletContext = session.getServletContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getServletContext(...)");
        this(string, servletContext, session.getLastAccessedTime(), session.getMaxInactiveInterval());
        this.copyAttributes(session);
    }

    public final void destroy() {
        this.attributes.clear();
    }

    public long getCreationTime() {
        this.checkValid();
        return this.creationTime;
    }

    @NotNull
    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return 0L;
    }

    @NotNull
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Nullable
    public Object getAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        return this.attributes.get(name);
    }

    @NotNull
    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        Enumeration<String> enumeration = this.attributes.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        return enumeration;
    }

    public void setAttribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        MockHttpEnvironmentKt.putOrRemove(this.attributes, name, value);
    }

    public void removeAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        this.attributes.remove(name);
    }

    @NotNull
    public final MockHttpSession copyAttributes(@NotNull HttpSession httpSession) {
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Enumeration enumeration = httpSession.getAttributeNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getAttributeNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Map)this.attributes).put(it, httpSession.getAttribute(it));
        }
        return this;
    }

    public void invalidate() {
        this.checkValid();
        this.valid.set(false);
    }

    public boolean isNew() {
        this.checkValid();
        return false;
    }

    private final void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("invalidated: " + this);
        }
    }

    @NotNull
    public String toString() {
        return "MockHttpSession(sessionId='" + this.sessionId + "', creationTime=" + this.creationTime + ", maxInactiveInterval=" + this.maxInactiveInterval + ", attributes=" + this.attributes + ", isValid=" + this.isValid() + ')';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vaadin/testbench/unit/mocks/MockHttpSession$Companion;", "", "<init>", "()V", "sessionIdGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lcom/vaadin/testbench/unit/mocks/MockHttpSession;", "ctx", "Ljakarta/servlet/ServletContext;", "vaadin-testbench-unit-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MockHttpSession create(@NotNull ServletContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new MockHttpSession(String.valueOf(sessionIdGenerator.incrementAndGet()), ctx, System.currentTimeMillis(), 30);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

