/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.upload.MultiFileReceiver;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.TransferUtil;
import com.vaadin.flow.server.communication.streaming.StreamingEndEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingErrorEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingStartEventImpl;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.server.streams.UploadResult;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import com.vaadin.testbench.unit.internal.MockVaadin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Tests(value={Upload.class})
@Deprecated(forRemoval=true, since="10.1")
public class UploadTester<T extends Upload>
extends ComponentTester<T> {
    public UploadTester(T component) {
        super(component);
    }

    public void upload(String fileName, String contentType, InputStream contents) {
        this.doUpload(List.of(new UploadItem(fileName, contentType, contents::readAllBytes)));
    }

    public void upload(String fileName, String contentType, byte[] contents) {
        this.doUpload(List.of(new UploadItem(fileName, contentType, () -> contents)));
    }

    public void upload(File file) {
        this.doUpload(List.of(new UploadItem(file.getName(), URLConnection.guessContentTypeFromName(file.getName()), () -> Files.readAllBytes(file.toPath()))));
    }

    public void uploadAll(File ... files) {
        this.uploadAll(List.of(files));
    }

    public void uploadAll(Collection<File> files) {
        Receiver receiver = ((Upload)this.getComponent()).getReceiver();
        if (receiver != null && !(receiver instanceof MultiFileReceiver)) {
            throw new IllegalStateException("Upload component is not configured with a MultiFileReceiver");
        }
        if (files.isEmpty()) {
            throw new IllegalArgumentException("At least one file must be provided");
        }
        this.doUpload(files.stream().map(f -> new UploadItem(f.getName(), URLConnection.guessContentTypeFromName(f.getName()), () -> Files.readAllBytes(f.toPath()))).collect(Collectors.toList()));
    }

    public void uploadAborted(String fileName, String contentType) {
        this.doFailUpload(fileName, contentType);
    }

    public void uploadAborted(File file) {
        this.doFailUpload(file.getName(), URLConnection.guessContentTypeFromName(file.getName()));
    }

    public void uploadFailed(File file) {
        this.doFailUpload(file.getName(), URLConnection.guessContentTypeFromName(file.getName()));
    }

    public void uploadFailed(String fileName, String contentType) {
        this.doFailUpload(fileName, contentType);
    }

    private void fireAllFinish() {
        try {
            this.getMethod("fireAllFinish", new Class[0]).invoke(this.getComponent(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFailUpload(String fileName, String contentType) {
        this.ensureComponentIsUsable();
        if (this.useLegacyAPI()) {
            StreamVariable streamVariable = this.getGetStreamVariable();
            try {
                streamVariable.streamingStarted((StreamVariable.StreamingStartEvent)new StreamingStartEventImpl(fileName, contentType, 0L));
                streamVariable.streamingFailed((StreamVariable.StreamingErrorEvent)new StreamingErrorEventImpl(fileName, contentType, 0L, 0L, null));
            }
            finally {
                this.fireAllFinish();
            }
        }
        try {
            this.doUpload(List.of(new UploadItem(fileName, contentType, null)));
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpload(Collection<UploadItem> items) {
        if (this.useLegacyAPI()) {
            this.doLegacyUpload(items);
        } else {
            this.roundTrip();
            String target = ((Upload)this.getComponent()).getElement().getAttribute("target");
            StreamResourceRegistry.ElementStreamResource resource = (StreamResourceRegistry.ElementStreamResource)VaadinSession.getCurrent().getResourceRegistry().getResource(StreamResourceRegistry.ElementStreamResource.class, URI.create(target)).orElseThrow(() -> new IllegalStateException("Upload handler is not registered"));
            ElementRequestHandler elementRequestHandler = resource.getElementRequestHandler();
            if (elementRequestHandler instanceof UploadHandler) {
                RuntimeException caughtException;
                UploadHandler uploadHandler = (UploadHandler)elementRequestHandler;
                try {
                    items.forEach(item -> this.doUpload((UploadItem)item, uploadHandler));
                }
                finally {
                    caughtException = this.runUIQueue();
                    this.fireAllFinish();
                }
                if (caughtException != null) {
                    throw caughtException;
                }
            } else {
                throw new IllegalStateException("Invalid or null upload handler " + String.valueOf(resource.getElementRequestHandler()));
            }
        }
    }

    private boolean useLegacyAPI() {
        return ((Upload)this.getComponent()).getReceiver() != null;
    }

    private RuntimeException runUIQueue() {
        try {
            MockVaadin.runUIQueue();
        }
        catch (RuntimeException ex) {
            return ex;
        }
        catch (Exception ex) {
            if (ex instanceof ExecutionException) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)throwable;
                    throw re;
                }
                throw new RuntimeException(ex.getCause());
            }
            return new RuntimeException(ex);
        }
        return null;
    }

    private void doUpload(UploadItem item, UploadHandler uploadHandler) {
        InputStream inputStream;
        long contentLength;
        if (item.contentsProducer == null) {
            contentLength = 0L;
            inputStream = new InputStream(this){

                @Override
                public int read() throws IOException {
                    throw new IOException("Simulated upload failure");
                }
            };
        } else {
            byte[] content = UploadTester.getUploadedItemContent(item.contentsProducer);
            contentLength = content.length;
            inputStream = new ByteArrayInputStream(content);
        }
        UploadEvent event = new UploadEvent(this, VaadinRequest.getCurrent(), VaadinResponse.getCurrent(), VaadinSession.getCurrent(), item.fileName, contentLength, item.contentType, ((Upload)this.getComponent()).getElement(), null){

            public InputStream getInputStream() {
                return inputStream;
            }
        };
        try {
            Method method = TransferUtil.class.getDeclaredMethod("handleUploadRequest", UploadHandler.class, UploadEvent.class);
            method.setAccessible(true);
            method.invoke(null, uploadHandler, event);
            uploadHandler.responseHandled(new UploadResult(true, VaadinResponse.getCurrent()));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("Cannot handle upload request", e);
        }
        catch (InvocationTargetException e) {
            RuntimeException cause;
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re;
                cause = re = (RuntimeException)throwable;
            } else {
                throwable = e.getCause();
                if (throwable instanceof IOException) {
                    IOException ioe = (IOException)throwable;
                    cause = new UncheckedIOException(ioe);
                } else {
                    cause = new UncheckedIOException(new IOException(e));
                }
            }
            uploadHandler.responseHandled(new UploadResult(false, VaadinResponse.getCurrent(), (Exception)cause));
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLegacyUpload(Collection<UploadItem> items) {
        this.ensureComponentIsUsable();
        try {
            StreamVariable streamVariable = this.getGetStreamVariable();
            AtomicReference errorCollector = new AtomicReference();
            List<StreamVariable.StreamingEvent> events = items.stream().map(item -> this.doUpload(streamVariable, (UploadItem)item, ex -> errorCollector.compareAndSet(null, ex))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            events.forEach(ev -> this.handleUploadResult(streamVariable, (StreamVariable.StreamingEvent)ev));
            Exception ex = (Exception)errorCollector.get();
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof IOException) {
                throw new UncheckedIOException((IOException)ex);
            }
            if (ex != null) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.fireAllFinish();
        }
    }

    private Optional<StreamVariable.StreamingEvent> doUpload(StreamVariable streamVariable, UploadItem item, Consumer<Exception> errorHandler) {
        String fileName = item.fileName;
        String contentType = item.contentType;
        Callable<byte[]> contentsProducer = item.contentsProducer;
        byte[] contents = UploadTester.getUploadedItemContent(contentsProducer);
        try {
            streamVariable.streamingStarted((StreamVariable.StreamingStartEvent)new StreamingStartEventImpl(fileName, contentType, (long)contents.length));
            streamVariable.getOutputStream().write(contents);
            return Optional.of(new StreamingEndEventImpl(fileName, contentType, (long)contents.length));
        }
        catch (IOException ex) {
            errorHandler.accept(ex);
        }
        catch (Exception ex) {
            errorHandler.accept(ex);
            return Optional.of(new StreamingErrorEventImpl(fileName, contentType, (long)contents.length, 0L, ex));
        }
        return Optional.empty();
    }

    private static byte[] getUploadedItemContent(Callable<byte[]> contentsProducer) {
        byte[] contents;
        try {
            contents = contentsProducer.call();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (Exception ex) {
            throw new UncheckedIOException(new IOException(ex));
        }
        Objects.requireNonNull(contents, "file contents cannot be null");
        return contents;
    }

    private void handleUploadResult(StreamVariable streamVariable, StreamVariable.StreamingEvent event) {
        if (event instanceof StreamVariable.StreamingErrorEvent) {
            streamVariable.streamingFailed((StreamVariable.StreamingErrorEvent)event);
        } else if (event instanceof StreamVariable.StreamingEndEvent) {
            streamVariable.streamingFinished((StreamVariable.StreamingEndEvent)event);
        }
    }

    private StreamVariable getGetStreamVariable() {
        try {
            return (StreamVariable)this.getMethod("getStreamVariable", new Class[0]).invoke(this.getComponent(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UploadItem {
        private final String fileName;
        private final String contentType;
        private final Callable<byte[]> contentsProducer;

        UploadItem(String fileName, String contentType, Callable<byte[]> contentsProducer) {
            this.fileName = Objects.requireNonNull(fileName, "fileName cannot be null");
            this.contentType = contentType;
            this.contentsProducer = contentsProducer;
        }
    }
}

