/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.mocks;

import com.vaadin.testbench.unit.mocks.SessionAttributeEntrySet;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableMap;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/vaadin/testbench/unit/mocks/SessionAttributeMap;", "Lkotlin/collections/AbstractMutableMap;", "", "", "session", "Ljakarta/servlet/http/HttpSession;", "<init>", "(Ljakarta/servlet/http/HttpSession;)V", "getSession", "()Ljakarta/servlet/http/HttpSession;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "get", "key", "put", "value", "remove", "", "isEmpty", "containsKey", "vaadin-testbench-unit-shared"})
final class SessionAttributeMap
extends AbstractMutableMap<String, Object> {
    @NotNull
    private final HttpSession session;
    @NotNull
    private final Set<Map.Entry<String, Object>> entries;

    public SessionAttributeMap(@NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.entries = (Set)((Object)new SessionAttributeEntrySet(this.session));
    }

    @NotNull
    public final HttpSession getSession() {
        return this.session;
    }

    @NotNull
    public Set<Map.Entry<String, Object>> getEntries() {
        return this.entries;
    }

    @Nullable
    public Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.session.getAttribute(key);
    }

    @Nullable
    public Object put(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object old = this.session.getAttribute(key);
        this.session.setAttribute(key, value);
        return old;
    }

    @Nullable
    public Object remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object old = this.session.getAttribute(key);
        this.session.removeAttribute(key);
        return old;
    }

    public boolean remove(@NotNull String key, @NotNull Object value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.get((Object)key), (Object)value)) {
            this.remove((Object)key);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.session.getAttribute(key) != null;
    }
}

