/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.virtuallist;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.virtuallist.VirtualList;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.LitRendererTestUtil;
import com.vaadin.testbench.unit.Tests;
import java.lang.reflect.Field;
import java.util.Collections;
import tools.jackson.databind.node.ArrayNode;

@Tests(value={VirtualList.class})
public class VirtualListTester<T extends VirtualList<Y>, Y>
extends ComponentTester<T> {
    private static final int SANE_FETCH_LIMIT = 2147483;

    public VirtualListTester(T component) {
        super(component);
    }

    public int size() {
        this.ensureVisible();
        DataCommunicator dataCommunicator = ((VirtualList)this.getComponent()).getDataCommunicator();
        return dataCommunicator.isDefinedSize() ? dataCommunicator.getDataProviderSize() : dataCommunicator.getDataProvider().fetch(this.saneQuery()).toList().size();
    }

    public Y getItem(int index) {
        this.ensureVisible();
        return (Y)((VirtualList)this.getComponent()).getDataCommunicator().getItem(index);
    }

    public String getItemText(int index) {
        this.ensureVisible();
        Renderer<Y> itemRenderer = this.getItemRenderer();
        if (itemRenderer instanceof ComponentRenderer) {
            Component component = this.getItemComponent(index);
            if (component == null) {
                return null;
            }
            return component.getElement().getTextRecursively();
        }
        if (itemRenderer instanceof LitRenderer) {
            LitRenderer litRenderer = (LitRenderer)itemRenderer;
            if (LitRendererTestUtil.getProperties(litRenderer, (x$0, x$1) -> this.getField((Class)x$0, (String)x$1)).stream().allMatch(propertyName -> propertyName.equals("label")) && LitRendererTestUtil.getFunctionNames(litRenderer, (x$0, x$1) -> this.getField((Class)x$0, (String)x$1)).isEmpty()) {
                return this.getLitRendererPropertyValue(index, "label", String.class);
            }
            throw new UnsupportedOperationException("VirtualListTester is unable to get item text when VirtualList uses a LitRenderer.");
        }
        throw new UnsupportedOperationException("VirtualListTester is unable to get item text for this VirtualList's renderer.");
    }

    public Component getItemComponent(int index) {
        this.ensureVisible();
        Renderer<Y> renderer = this.getItemRenderer();
        if (renderer instanceof ComponentRenderer) {
            ComponentRenderer componentRenderer = (ComponentRenderer)renderer;
            Y item = this.getItem(index);
            return componentRenderer.createComponent(item);
        }
        throw new IllegalArgumentException("VirtualList doesn't use a ComponentRenderer.");
    }

    private Renderer<Y> getItemRenderer() {
        Field rendererField = this.getField("renderer");
        try {
            return (Renderer)rendererField.get(this.getComponent());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V getLitRendererPropertyValue(int index, String propertyName, Class<V> propertyClass) {
        this.ensureVisible();
        Renderer<Y> renderer = this.getItemRenderer();
        if (renderer instanceof LitRenderer) {
            LitRenderer litRenderer = (LitRenderer)renderer;
            return LitRendererTestUtil.getPropertyValue(litRenderer, (x$0, x$1) -> this.getField((Class)x$0, (String)x$1), this::getItem, index, propertyName, propertyClass);
        }
        throw new IllegalArgumentException("This VirtualList doesn't use a LitRenderer.");
    }

    public void invokeLitRendererFunction(int index, String functionName, ArrayNode jsonArray) {
        this.ensureVisible();
        Renderer<Y> renderer = this.getItemRenderer();
        if (!(renderer instanceof LitRenderer)) {
            throw new IllegalArgumentException("This VirtualList doesn't use a LitRenderer.");
        }
        LitRenderer litRenderer = (LitRenderer)renderer;
        LitRendererTestUtil.invokeFunction(litRenderer, (x$0, x$1) -> this.getField((Class)x$0, (String)x$1), this::getItem, index, functionName, jsonArray);
    }

    public void invokeLitRendererFunction(int index, String functionName) {
        this.invokeLitRendererFunction(index, functionName, JacksonUtils.createArrayNode());
    }

    private <F> Query<Y, F> saneQuery() {
        return new Query(0, 2147483, Collections.emptyList(), null, null);
    }
}

