/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.testbench.unit.ComponentQuery;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import com.vaadin.testbench.unit.internal.PrettyPrintTreeKt;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import tools.jackson.databind.JsonNode;

@Tests(value={ContextMenu.class})
public class ContextMenuTester<T extends ContextMenu>
extends ComponentTester<T> {
    public ContextMenuTester(T component) {
        super(component);
    }

    public void open() {
        if (((ContextMenu)this.getComponent()).isOpened()) {
            throw new IllegalStateException("Context menu is already open");
        }
        this.attachMenuToUI();
        this.roundTrip();
        ((ContextMenu)this.getComponent()).getElement().setProperty("opened", true);
        this.ensureComponentIsUsable();
    }

    public void close() {
        this.ensureComponentIsUsable();
        ((ContextMenu)this.getComponent()).getElement().setProperty("opened", false);
    }

    public void clickItem(String topLevelText, String ... nestedItemsText) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelText, nestedItemsText);
        this.clickMenuItem(menuItem);
    }

    public void clickItem(int topLevelPosition, int ... nestedItemsPositions) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelPosition, nestedItemsPositions);
        this.clickMenuItem(menuItem);
    }

    public boolean isItemChecked(String topLevelText, String ... nestedItemsText) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelText, nestedItemsText);
        if (!menuItem.isCheckable()) {
            String fullPath = topLevelText + (String)(nestedItemsText.length > 0 ? " / " + String.join((CharSequence)" / ", nestedItemsText) : "");
            throw new IllegalArgumentException("Menu item at position " + fullPath + " is not a checkable menu item");
        }
        return menuItem.isChecked();
    }

    public boolean isItemChecked(int topLevelPosition, int ... nestedItemsPositions) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelPosition, nestedItemsPositions);
        if (!menuItem.isCheckable()) {
            String fullPath = IntStream.concat(IntStream.of(topLevelPosition), IntStream.of(nestedItemsPositions)).mapToObj(Integer::toString).collect(Collectors.joining(" / "));
            throw new IllegalArgumentException("Menu item at position " + fullPath + " is not a checkable menu item");
        }
        return menuItem.isChecked();
    }

    @Override
    public <R extends Component> ComponentQuery<R> find(Class<R> componentType) {
        return super.find(componentType);
    }

    private MenuItem findMenuItemByPath(String topLevelText, String ... nestedItemsText) {
        MenuItem menuItem = this.findMenuItem((MenuManager<ContextMenu, MenuItem, SubMenu>)((ContextMenu)this.getComponent()).getMenuManager(), topLevelText, null);
        if (nestedItemsText.length > 0) {
            String path = topLevelText + " / " + String.join((CharSequence)" / ", nestedItemsText);
            for (String text : nestedItemsText) {
                if (!menuItem.isParentItem()) {
                    throw new IllegalArgumentException("Menu item with text " + menuItem.getText() + " has no children. Make sure that the path is correct: " + path);
                }
                menuItem = this.findMenuItem((MenuManager<ContextMenu, MenuItem, SubMenu>)((SubMenu)menuItem.getSubMenu()).getMenuManager(), text, path);
            }
        }
        return menuItem;
    }

    private MenuItem findMenuItem(MenuManager<ContextMenu, MenuItem, SubMenu> menuManager, String text, String fullPath) {
        List items = menuManager.getItems().stream().filter(item -> text.equals(item.getText())).collect(Collectors.toList());
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot find menu item with text " + text + (String)(fullPath != null ? " on path " + fullPath : ""));
        }
        if (items.size() > 1) {
            throw new IllegalStateException("Expecting a single menu item with text " + text + " but found " + items.size() + (String)(fullPath != null ? " on path " + fullPath : ""));
        }
        MenuItem menuItem = (MenuItem)items.get(0);
        this.ensureMenuItemIsUsable(menuItem, fullPath);
        return menuItem;
    }

    private MenuItem findMenuItemByPath(int topLevelPosition, int ... nestedItemsPositions) {
        MenuItem menuItem = this.findMenuItemByPosition((MenuManager<ContextMenu, MenuItem, SubMenu>)((ContextMenu)this.getComponent()).getMenuManager(), topLevelPosition, null);
        if (nestedItemsPositions.length > 0) {
            StringBuilder path = new StringBuilder().append(topLevelPosition);
            for (int position : nestedItemsPositions) {
                if (!menuItem.isParentItem()) {
                    throw new IllegalArgumentException("Menu item with text " + menuItem.getText() + " has no children. Make sure that the path is correct: " + String.valueOf(path));
                }
                path.append(" / ").append(position);
                menuItem = this.findMenuItemByPosition((MenuManager<ContextMenu, MenuItem, SubMenu>)((SubMenu)menuItem.getSubMenu()).getMenuManager(), position, path.toString());
            }
        }
        return menuItem;
    }

    private MenuItem findMenuItemByPosition(MenuManager<ContextMenu, MenuItem, SubMenu> menuManager, int position, String fullPath) {
        MenuItem menuItem = menuManager.getItems().stream().filter(Component::isVisible).skip(position).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find menu item at position " + fullPath));
        this.ensureMenuItemIsUsable(menuItem, fullPath);
        return menuItem;
    }

    private void ensureMenuItemIsUsable(MenuItem menuItem, String fullPath) {
        if (!menuItem.isEnabled() || !menuItem.isVisible()) {
            throw new IllegalStateException("Menu item " + fullPath + " is not usable. " + PrettyPrintTreeKt.toPrettyTree((Component)menuItem));
        }
    }

    private void clickMenuItem(MenuItem menuItem) {
        if (menuItem.isCheckable()) {
            menuItem.setChecked(!menuItem.isChecked());
        }
        ComponentUtil.fireEvent((Component)menuItem, (ComponentEvent)new ClickEvent((Component)menuItem, true, 0, 0, 0, 0, 1, 0, false, false, false, false));
    }

    private void attachMenuToUI() {
        Element target = ((ContextMenu)this.getComponent()).getTarget().getElement();
        DomEvent beforeOpen = new DomEvent(target, "vaadin-context-menu-before-open", (JsonNode)JacksonUtils.createObjectNode());
        this.fireDomEvent(beforeOpen);
    }
}

