/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.RouteRegistryInitializer;
import com.vaadin.testbench.unit.internal.MockInternalSeverError;
import com.vaadin.testbench.unit.internal.MockRouteNotFoundError;
import com.vaadin.testbench.unit.internal.RoutesKt;
import com.vaadin.testbench.unit.internal.UtilsKt;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00040\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J'\u0010\u0017\u001a\u00020\u00002\u0018\b\u0002\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001a0\u0019\"\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0017\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003J\u001b\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00040\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003JG\u0010#\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u00032\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00040\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010$\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/vaadin/testbench/unit/internal/Routes;", "Ljava/io/Serializable;", "routes", "", "Ljava/lang/Class;", "Lcom/vaadin/flow/component/Component;", "errorRoutes", "Lcom/vaadin/flow/router/HasErrorParameter;", "skipPwaInit", "", "<init>", "(Ljava/util/Set;Ljava/util/Set;Z)V", "getRoutes", "()Ljava/util/Set;", "getErrorRoutes", "getSkipPwaInit", "()Z", "setSkipPwaInit", "(Z)V", "register", "", "sc", "Lcom/vaadin/flow/server/VaadinContext;", "autoDiscoverViews", "packageNames", "", "", "([Ljava/lang/String;)Lcom/vaadin/testbench/unit/internal/Routes;", "merge", "other", "toString", "cleanupErrorRoutes", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "", "vaadin-testbench-unit-shared"})
@SourceDebugExtension(value={"SMAP\nRoutes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Routes.kt\ncom/vaadin/testbench/unit/internal/Routes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,182:1\n1563#2:183\n1634#2,3:184\n1634#2,3:193\n1634#2,3:196\n1761#2,3:199\n11561#3:187\n11896#3,3:188\n37#4,2:191\n*S KotlinDebug\n*F\n+ 1 Routes.kt\ncom/vaadin/testbench/unit/internal/Routes\n*L\n60#1:183\n60#1:184,3\n81#1:193,3\n84#1:196,3\n109#1:199,3\n79#1:187\n79#1:188,3\n79#1:191,2\n*E\n"})
public final class Routes
implements Serializable {
    @NotNull
    private final Set<Class<? extends Component>> routes;
    @NotNull
    private final Set<Class<? extends HasErrorParameter<?>>> errorRoutes;
    private boolean skipPwaInit;

    public Routes(@NotNull Set<Class<? extends Component>> routes, @NotNull Set<Class<? extends HasErrorParameter<?>>> errorRoutes, boolean skipPwaInit) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Intrinsics.checkNotNullParameter(errorRoutes, (String)"errorRoutes");
        this.routes = routes;
        this.errorRoutes = errorRoutes;
        this.skipPwaInit = skipPwaInit;
    }

    public /* synthetic */ Routes(Set set, Set set2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 2) != 0) {
            Object[] objectArray = new Class[]{MockRouteNotFoundError.class};
            set2 = SetsKt.mutableSetOf((Object[])objectArray);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(set, set2, bl);
    }

    @NotNull
    public final Set<Class<? extends Component>> getRoutes() {
        return this.routes;
    }

    @NotNull
    public final Set<Class<? extends HasErrorParameter<?>>> getErrorRoutes() {
        return this.errorRoutes;
    }

    public final boolean getSkipPwaInit() {
        return this.skipPwaInit;
    }

    public final void setSkipPwaInit(boolean bl) {
        this.skipPwaInit = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void register(@NotNull VaadinContext sc) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        new RouteRegistryInitializer().onStartup(CollectionsKt.toSet((Iterable)this.routes), UtilsKt.getContext(sc));
        if (UtilsKt.getContext(sc).getAttribute("com.vaadin.flow.server.startup.ApplicationRouteRegistry$ApplicationRouteRegistryWrapper") == null) {
            boolean $i$a$-checkNotNull-Routes$register$22 = false;
            String $i$a$-checkNotNull-Routes$register$22 = "RouteRegistryInitializer did not register the ApplicationRouteRegistry!";
            throw new IllegalStateException($i$a$-checkNotNull-Routes$register$22.toString());
        }
        ApplicationRouteRegistry applicationRouteRegistry = ApplicationRouteRegistry.getInstance((VaadinContext)sc);
        Intrinsics.checkNotNullExpressionValue((Object)applicationRouteRegistry, (String)"getInstance(...)");
        ApplicationRouteRegistry registry = applicationRouteRegistry;
        Iterable $i$a$-checkNotNull-Routes$register$22 = this.errorRoutes;
        ApplicationRouteRegistry applicationRouteRegistry2 = registry;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Class clazz = (Class)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.lang.Class<out com.vaadin.flow.component.Component>");
            collection.add(it);
        }
        applicationRouteRegistry2.setErrorNavigationTargets(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        if (this.skipPwaInit) {
            RoutesKt.clearPwaClass(registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Routes autoDiscoverViews(String ... packageNames) {
        void $this$toTypedArray$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Routes routes;
        Intrinsics.checkNotNullParameter((Object)packageNames, (String)"packageNames");
        Routes $this$autoDiscoverViews_u24lambda_u240 = routes = this;
        boolean bl = false;
        Object object = packageNames;
        ClassGraph classGraph = new ClassGraph().enableClassInfo().enableAnnotationInfo();
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (ClassInfo item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            collection = item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            String string = it;
            if (string == null) {
                string = "";
            }
            collection2.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        Object object2 = thisCollection$iv.toArray(new String[0]);
        ClassGraph classGraph2 = classGraph.acceptPackages(Arrays.copyOf(object2, ((String[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)classGraph2, (String)"acceptPackages(...)");
        ClassGraph classGraph3 = classGraph2;
        Closeable closeable = (Closeable)classGraph3.scan();
        object2 = null;
        try {
            ClassInfo info;
            Iterable $this$mapTo$iv;
            ScanResult scanResult = (ScanResult)closeable;
            boolean bl3 = false;
            ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(Route.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)classInfoList, (String)"getClassesWithAnnotation(...)");
            thisCollection$iv = (Iterable)classInfoList;
            Collection destination$iv = $this$autoDiscoverViews_u24lambda_u240.routes;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                ClassInfo item$iv$iv;
                item$iv$iv = (ClassInfo)item$iv;
                collection = destination$iv;
                boolean bl4 = false;
                String string = info.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                collection.add(UtilsKt.findClassOrThrow(string).asSubclass(Component.class));
            }
            ClassInfoList classInfoList2 = scanResult.getClassesImplementing(HasErrorParameter.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)classInfoList2, (String)"getClassesImplementing(...)");
            $this$mapTo$iv = (Iterable)classInfoList2;
            destination$iv = $this$autoDiscoverViews_u24lambda_u240.errorRoutes;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                info = (ClassInfo)item$iv;
                collection = destination$iv;
                boolean bl5 = false;
                String string = info.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                collection.add(UtilsKt.findClassOrThrow(string).asSubclass(HasErrorParameter.class));
            }
            object = (Set)destination$iv;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        $this$autoDiscoverViews_u24lambda_u240.cleanupErrorRoutes();
        System.out.println((Object)("Auto-discovered views: " + $this$autoDiscoverViews_u24lambda_u240));
        return routes;
    }

    public static /* synthetic */ Routes autoDiscoverViews$default(Routes routes, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            stringArray = new String[]{};
        }
        return routes.autoDiscoverViews(stringArray);
    }

    @NotNull
    public final Routes merge(@NotNull Routes other) {
        Routes routes;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Routes $this$merge_u24lambda_u240 = routes = new Routes(new LinkedHashSet(this.routes), new LinkedHashSet(this.errorRoutes), this.skipPwaInit);
        boolean bl = false;
        $this$merge_u24lambda_u240.routes.addAll((Collection<Class<? extends Component>>)other.routes);
        $this$merge_u24lambda_u240.errorRoutes.addAll((Collection)other.errorRoutes);
        $this$merge_u24lambda_u240.cleanupErrorRoutes();
        return routes;
    }

    @NotNull
    public String toString() {
        return "Routes(routes=" + CollectionsKt.joinToString$default((Iterable)this.routes, null, null, null, (int)0, null, Routes::toString$lambda$0, (int)31, null) + ", errorRoutes=" + CollectionsKt.joinToString$default((Iterable)this.errorRoutes, null, null, null, (int)0, null, Routes::toString$lambda$1, (int)31, null) + ')';
    }

    private final void cleanupErrorRoutes() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.errorRoutes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, MockRouteNotFoundError.class) && UtilsKt.isRouteNotFound(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.errorRoutes.remove(MockRouteNotFoundError.class);
        }
        this.errorRoutes.remove(InternalServerError.class);
        this.errorRoutes.add(MockInternalSeverError.class);
    }

    @NotNull
    public final Set<Class<? extends Component>> component1() {
        return this.routes;
    }

    @NotNull
    public final Set<Class<? extends HasErrorParameter<?>>> component2() {
        return this.errorRoutes;
    }

    public final boolean component3() {
        return this.skipPwaInit;
    }

    @NotNull
    public final Routes copy(@NotNull Set<Class<? extends Component>> routes, @NotNull Set<Class<? extends HasErrorParameter<?>>> errorRoutes, boolean skipPwaInit) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Intrinsics.checkNotNullParameter(errorRoutes, (String)"errorRoutes");
        return new Routes(routes, errorRoutes, skipPwaInit);
    }

    public static /* synthetic */ Routes copy$default(Routes routes, Set set, Set set2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = routes.routes;
        }
        if ((n & 2) != 0) {
            set2 = routes.errorRoutes;
        }
        if ((n & 4) != 0) {
            bl = routes.skipPwaInit;
        }
        return routes.copy(set, set2, bl);
    }

    public int hashCode() {
        int result = ((Object)this.routes).hashCode();
        result = result * 31 + ((Object)this.errorRoutes).hashCode();
        result = result * 31 + Boolean.hashCode(this.skipPwaInit);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Routes)) {
            return false;
        }
        Routes routes = (Routes)other;
        if (!Intrinsics.areEqual(this.routes, routes.routes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorRoutes, routes.errorRoutes)) {
            return false;
        }
        return this.skipPwaInit == routes.skipPwaInit;
    }

    @JvmOverloads
    @NotNull
    public final Routes autoDiscoverViews() {
        return Routes.autoDiscoverViews$default(this, null, 1, null);
    }

    private static final CharSequence toString$lambda$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    private static final CharSequence toString$lambda$1(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    public Routes() {
        this(null, null, false, 7, null);
    }
}

