/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.internal;

import java.io.Serializable;
import java.util.Locale;

public class SharedUtil
implements Serializable {
    public static String trimTrailingSlashes(String value) {
        return value.replaceAll("/*$", "");
    }

    public static String[] splitCamelCase(String camelCaseString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelCaseString.length(); ++i) {
            char c = camelCaseString.charAt(i);
            if (Character.isUpperCase(c) && SharedUtil.isWordComplete(camelCaseString, i)) {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString().split(" ");
    }

    private static boolean isWordComplete(String camelCaseString, int i) {
        if (i == 0) {
            return false;
        }
        if (!Character.isUpperCase(camelCaseString.charAt(i - 1))) {
            return true;
        }
        return i + 1 < camelCaseString.length() && !Character.isUpperCase(camelCaseString.charAt(i + 1));
    }

    public static String camelCaseToHumanFriendly(String camelCaseString) {
        String[] parts = SharedUtil.splitCamelCase(camelCaseString);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = SharedUtil.capitalize(parts[i]);
        }
        return SharedUtil.join(parts, " ");
    }

    public static String join(String[] parts, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
            sb.append(separator);
        }
        return sb.substring(0, sb.length() - separator.length());
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 1) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String firstToLower(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 1) {
            return string.toLowerCase(Locale.ENGLISH);
        }
        return string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String propertyIdToHumanFriendly(Object propertyId) {
        String string = propertyId.toString();
        if (string.isEmpty()) {
            return "";
        }
        int dotLocation = string.lastIndexOf(46);
        if (dotLocation > 0 && dotLocation < string.length() - 1) {
            string = string.substring(dotLocation + 1);
        }
        return SharedUtil.camelCaseToHumanFriendly(string);
    }

    public static String addGetParameter(String uri, String parameter, String value) {
        return SharedUtil.addGetParameters(uri, parameter + "=" + value);
    }

    public static String addGetParameter(String uri, String parameter, int value) {
        return SharedUtil.addGetParameter(uri, parameter, Integer.toString(value));
    }

    public static String addGetParameters(String uri, String extraParams) {
        if (extraParams == null || extraParams.length() == 0) {
            return uri;
        }
        String fragment = null;
        int hashPosition = ((String)uri).indexOf(35);
        if (hashPosition != -1) {
            fragment = ((String)uri).substring(hashPosition);
            uri = ((String)uri).substring(0, hashPosition);
        }
        uri = ((String)uri).contains("?") ? (String)uri + "&" : (String)uri + "?";
        uri = (String)uri + extraParams;
        if (fragment != null) {
            uri = (String)uri + fragment;
        }
        return uri;
    }

    public static String dashSeparatedToCamelCase(String dashSeparated) {
        if (dashSeparated == null) {
            return null;
        }
        String[] parts = dashSeparated.split("-");
        for (int i = 1; i < parts.length; ++i) {
            parts[i] = SharedUtil.capitalize(parts[i]);
        }
        return SharedUtil.join(parts, "");
    }

    public static String camelCaseToDashSeparated(String camelCaseString) {
        if (camelCaseString == null) {
            return null;
        }
        String[] parts = SharedUtil.splitCamelCase(camelCaseString);
        if (parts[0].length() >= 1 && Character.isUpperCase(parts[0].charAt(0))) {
            parts[0] = "-" + SharedUtil.firstToLower(parts[0]);
        }
        for (int i = 1; i < parts.length; ++i) {
            parts[i] = SharedUtil.firstToLower(parts[i]);
        }
        return SharedUtil.join(parts, "-");
    }
}

