/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.screenshot;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.screenshot.ImageComparisonUtil;
import com.vaadin.testbench.screenshot.ImageFileUtil;
import com.vaadin.testbench.screenshot.ImageUtil;
import com.vaadin.testbench.screenshot.ScreenShotFailureReporter;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.openqa.selenium.Capabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageComparison {
    private static final int BLOCK_SIZE = 16;
    private static final int MAX_CURSOR_Y_BLOCKS = 3;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ImageComparison.class);
    }

    public boolean imageEqualToReference(BufferedImage screenshotImage, String referenceFileId, double errorTolerance, Capabilities capabilities) throws IOException {
        ImageFileUtil.createScreenshotDirectoriesIfNeeded();
        List<String> referenceFileNames = ImageFileUtil.getReferenceImageFileNames(referenceFileId + ".png", capabilities);
        if (referenceFileNames.isEmpty()) {
            ImageIO.write((RenderedImage)screenshotImage, "png", ImageFileUtil.getErrorScreenshotFile(referenceFileId + ".png"));
            ImageComparison.getLogger().error("No reference found for " + referenceFileId + " in " + ImageFileUtil.getScreenshotReferenceDirectory());
            return false;
        }
        ScreenShotFailureReporter failureReporter = null;
        for (String referenceFileName : referenceFileNames) {
            BufferedImage referenceImage = ImageFileUtil.readReferenceImage(referenceFileName);
            failureReporter = this.compareImages(ImageComparison.createParameters(referenceImage, screenshotImage, errorTolerance));
            if (failureReporter != null) continue;
            return true;
        }
        if (failureReporter != null) {
            failureReporter.createErrorImageAndHTML(referenceFileId + ".png", screenshotImage);
        }
        return false;
    }

    public boolean imageEqualToReference(BufferedImage screenshotImage, BufferedImage referenceImage, String referenceFileName, double errorTolerance) {
        ImageFileUtil.createScreenshotDirectoriesIfNeeded();
        ComparisonParameters param = ImageComparison.createParameters(referenceImage, screenshotImage, errorTolerance);
        ScreenShotFailureReporter failureReporter = this.compareImages(param);
        if (failureReporter != null) {
            failureReporter.createErrorImageAndHTML(referenceFileName, screenshotImage);
            return false;
        }
        return true;
    }

    private ScreenShotFailureReporter compareImages(ComparisonParameters param) {
        Point possibleCursorPosition;
        boolean imagesEqual = this.compareImage(param);
        if (param.sizesDiffer) {
            if (Parameters.isDebug()) {
                if (imagesEqual) {
                    System.out.println("Images are of different size.");
                } else {
                    System.out.println("Images differ and are of different size.");
                }
            }
            ScreenShotFailureReporter fr = this.makeFailureReporter(param);
            return fr;
        }
        if (imagesEqual) {
            if (Parameters.isDebug()) {
                System.out.println("Screenshot matched reference");
            }
            return null;
        }
        if (Parameters.isScreenshotComparisonCursorDetection() && (possibleCursorPosition = ImageComparison.getPossibleCursorPosition(param)) != null) {
            if (this.isCursorTheOnlyError(possibleCursorPosition, param)) {
                if (Parameters.isDebug()) {
                    System.out.println("Screenshot matched reference after removing cursor");
                }
                return null;
            }
            if (Parameters.isDebug()) {
                System.out.println("Screenshot did not match reference after removing cursor");
            }
        }
        if (Parameters.isDebug()) {
            System.out.println("Screenshot did not match reference");
        }
        return this.makeFailureReporter(param);
    }

    private ScreenShotFailureReporter makeFailureReporter(ComparisonParameters param) {
        return new ScreenShotFailureReporter(param.refImage, param.falseBlocks);
    }

    public boolean compareImages(BufferedImage referenceImage, BufferedImage screenshotImage, double errorTolerance) {
        Point possibleCursorPosition;
        ComparisonParameters params = ImageComparison.createParameters(referenceImage, screenshotImage, errorTolerance);
        boolean imagesEqual = this.compareImage(params);
        if (!imagesEqual && Parameters.isScreenshotComparisonCursorDetection() && (possibleCursorPosition = ImageComparison.getPossibleCursorPosition(params)) != null && this.isCursorTheOnlyError(possibleCursorPosition, params)) {
            return true;
        }
        return imagesEqual;
    }

    private boolean compareImage(ComparisonParameters params) {
        boolean result = true;
        int imageWidth = params.width;
        int imageHeight = params.height;
        for (int y = 0; y < imageHeight; y += 16) {
            for (int x = 0; x < imageWidth; x += 16) {
                if (!this.blocksDiffer(x, y, params)) continue;
                params.falseBlocks[x >>> 4][y >>> 4] = true;
                result = false;
            }
        }
        return result;
    }

    private boolean blocksDiffer(int x, int y, ComparisonParameters params) {
        int[] refBlock = ImageUtil.getBlock(params.refProperties, x, y, params.refBlock, params.sampleBuffer);
        int[] ssBlock = ImageUtil.getBlock(params.ssProperties, x, y, params.ssBlock, params.sampleBuffer);
        for (int i = 0; i < 256; ++i) {
            if (refBlock[i] == ssBlock[i]) continue;
            return this.rgbCompare(refBlock, ssBlock) > params.errorTolerance;
        }
        return false;
    }

    private double rgbCompare(int[] referenceBlock, int[] screenshotBlock) {
        int sum = 0;
        assert (referenceBlock.length == screenshotBlock.length);
        int l = referenceBlock.length;
        for (int i = 0; i < l; ++i) {
            int targetPixel = referenceBlock[i];
            if (targetPixel >>> 24 < 255) continue;
            int testPixel = screenshotBlock[i];
            sum += Math.abs(((targetPixel & 0xFF0000) >> 16) - ((testPixel & 0xFF0000) >> 16));
            sum += Math.abs(((targetPixel & 0xFF00) >> 8) - ((testPixel & 0xFF00) >> 8));
            sum += Math.abs((targetPixel & 0xFF) - (testPixel & 0xFF));
        }
        return (double)sum / ((double)referenceBlock.length * 255.0 * 3.0);
    }

    private static Point getPossibleCursorPosition(ComparisonParameters params) {
        int firstErrorBlockX = 0;
        int firstErrorBlockY = 0;
        boolean errorFound = false;
        int xBlocks = params.xBlocks;
        int yBlocks = params.yBlocks;
        boolean[][] blocksWithErrors = params.falseBlocks;
        for (int y = 0; y < yBlocks; ++y) {
            for (int x = 0; x < xBlocks; ++x) {
                if (!blocksWithErrors[x][y]) continue;
                if (errorFound) {
                    if (x != firstErrorBlockX) {
                        return null;
                    }
                    if (y - firstErrorBlockY <= 2) continue;
                    return null;
                }
                firstErrorBlockX = x;
                firstErrorBlockY = y;
                errorFound = true;
            }
        }
        Point value = null;
        if (errorFound) {
            value = new Point(firstErrorBlockX << 4, firstErrorBlockY << 4);
        }
        return value;
    }

    private boolean isCursorTheOnlyError(Point possibleCursorPosition, ComparisonParameters params) {
        int l;
        int x = possibleCursorPosition.x;
        int y = possibleCursorPosition.y;
        int width = params.width <= x + 16 ? params.width - x : 16;
        int height = params.height <= y + 48 ? params.height - y : 48;
        if (Parameters.isDebug()) {
            System.out.println("Looking for cursor starting from " + x + "," + y + " using width=" + width + " and height=" + height);
        }
        int[] refBlock = params.refBlock;
        int[] ssBlock = params.ssBlock;
        int[] sampleBuffer = params.sampleBuffer;
        ImageUtil.ImageProperties refProperties = params.refProperties;
        ImageUtil.ImageProperties ssProperties = params.ssProperties;
        ImageUtil.getBlock(refProperties, x, y, refBlock, sampleBuffer);
        ImageUtil.getBlock(ssProperties, x, y, ssBlock, sampleBuffer);
        int cursorX = -1;
        int cursorStartY = -1;
        int n = l = height > 16 ? 16 : height;
        block0: for (int j = 0; j < l; ++j) {
            for (int i = 0; i < width; ++i) {
                if (!this.isCursorPixel(params.refBlock[i + j * width], params.ssBlock[i + j * width]) || j < l - 1 && !this.isCursorPixel(refBlock[i + (j + 1) * width], ssBlock[i + (j + 1) * width])) continue;
                cursorX = i;
                cursorStartY = j;
                if (!Parameters.isDebug()) break block0;
                System.out.println("Cursor found at " + cursorX + "," + cursorStartY);
                break block0;
            }
        }
        if (-1 == cursorX) {
            if (Parameters.isDebug()) {
                System.out.println("Cursor not found");
            }
            return false;
        }
        int cursorEndY = cursorStartY;
        int idx = cursorX + cursorEndY * width;
        int diff = 0;
        while (cursorEndY < height - 1 && cursorEndY < 48 && this.isCursorPixel(params.refBlock[idx], params.ssBlock[idx])) {
            if (++cursorEndY == 16) {
                params.refBlock = ImageUtil.getBlock(refProperties, x, y + 16, refBlock, sampleBuffer);
                params.ssBlock = ImageUtil.getBlock(ssProperties, x, y + 16, ssBlock, sampleBuffer);
                diff = width * 16;
            }
            idx = cursorX + cursorEndY * width - diff;
        }
        if (cursorEndY - cursorStartY < 5 && cursorStartY > 0 && cursorEndY < height - 1) {
            if (Parameters.isDebug()) {
                System.out.println("Cursor rejected at " + cursorX + "," + cursorStartY + "-" + cursorEndY);
            }
            return false;
        }
        if (Parameters.isDebug()) {
            System.out.println("Cursor is at " + cursorX + "," + cursorStartY + "-" + cursorEndY);
        }
        BufferedImage referenceCopy = params.refImage.getSubimage(x, y, width, height);
        BufferedImage screenshotCopy = ImageUtil.cloneImage(params.ssImage.getSubimage(x, y, width, height));
        for (int j = cursorStartY; j <= cursorEndY; ++j) {
            int referenceRgb = referenceCopy.getRGB(cursorX, j);
            screenshotCopy.setRGB(cursorX, j, referenceRgb);
        }
        return this.compareImage(ImageComparison.createParameters(referenceCopy, screenshotCopy, params.errorTolerance));
    }

    private final boolean isCursorPixel(int pixel1, int pixel2) {
        double lum1 = ImageUtil.getLuminance(pixel1);
        double lum2 = ImageUtil.getLuminance(pixel2);
        int blackMaxLuminance = 80;
        int whiteMinLuminance = 150;
        boolean value = lum1 < (double)blackMaxLuminance && lum2 > (double)whiteMinLuminance || lum1 > (double)whiteMinLuminance && lum2 < (double)blackMaxLuminance;
        return value;
    }

    private static final ComparisonParameters createParameters(BufferedImage reference, BufferedImage screenshot, double tolerance) {
        ComparisonParameters p = new ComparisonParameters();
        p.refImage = reference;
        p.ssImage = screenshot;
        p.refBlock = new int[256];
        p.ssBlock = new int[256];
        p.sampleBuffer = ImageUtil.createSampleBuffer();
        p.errorTolerance = tolerance;
        boolean bl = p.sizesDiffer = !ImageUtil.imagesSameSize(reference, screenshot);
        if (p.sizesDiffer) {
            List<BufferedImage> images = ImageUtil.cropToBeSameSize(reference, screenshot);
            p.refImage = images.get(0);
            p.ssImage = images.get(1);
        }
        p.width = p.refImage.getWidth();
        p.height = p.refImage.getHeight();
        p.xBlocks = ImageComparisonUtil.getNrBlocks(p.width);
        p.yBlocks = ImageComparisonUtil.getNrBlocks(p.height);
        p.falseBlocks = new boolean[p.xBlocks][p.yBlocks];
        p.refProperties = ImageUtil.getImageProperties(p.refImage);
        p.ssProperties = ImageUtil.getImageProperties(p.ssImage);
        return p;
    }

    private static class ComparisonParameters {
        private ImageUtil.ImageProperties refProperties = null;
        private ImageUtil.ImageProperties ssProperties = null;
        private BufferedImage refImage = null;
        private BufferedImage ssImage = null;
        private int[] refBlock = null;
        private int[] ssBlock = null;
        private int[] sampleBuffer = null;
        private boolean[][] falseBlocks = null;
        private int width = 0;
        private int height = 0;
        private int xBlocks = 0;
        private int yBlocks = 0;
        private double errorTolerance = 0.0;
        private boolean sizesDiffer = false;

        private ComparisonParameters() {
        }
    }
}

