/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel.setup;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.parallel.SauceLabsIntegration;
import java.net.URL;
import java.time.Duration;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDriver {
    private static final int BROWSER_INIT_ATTEMPTS = 5;

    public WebDriver createDriver(String hubURL, DesiredCapabilities capabilities) throws Exception {
        for (int i = 1; i <= 5; ++i) {
            try {
                ClientConfig config = ClientConfig.defaultConfig().readTimeout(Duration.ofSeconds(Parameters.getReadTimeout())).baseUrl(new URL(hubURL));
                HttpCommandExecutor executor = new HttpCommandExecutor(config);
                RemoteWebDriver driver = new RemoteWebDriver((CommandExecutor)executor, (Capabilities)capabilities);
                return TestBench.createDriver((WebDriver)driver);
            }
            catch (Exception e) {
                Object testInfo;
                if (i == 5) {
                    this.getLogger().error("Browser startup for {} failed on attempt {} (final attempt)", new Object[]{capabilities, i, e});
                    throw e;
                }
                String testName = this.getTestName(capabilities);
                Object object = testInfo = testName != null ? " for test " + testName : "";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Browser startup failed on attempt {}/{}{}, retrying... (capabilities: {})", new Object[]{i, 5, testInfo, capabilities, e});
                    continue;
                }
                this.getLogger().info("Browser startup failed on attempt {}/{}{}, retrying...", new Object[]{i, 5, testInfo});
                continue;
            }
        }
        return null;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private String getTestName(DesiredCapabilities capabilities) {
        Object testName = SauceLabsIntegration.getSauceLabsOption(capabilities, "name");
        if (testName != null) {
            return testName.toString();
        }
        testName = capabilities.getCapability("name");
        return testName != null ? testName.toString() : null;
    }
}

