/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.HasLabelAsText;
import com.vaadin.testbench.HasPlaceholder;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.annotations.Attribute;
import com.vaadin.testbench.elementsbase.Element;
import com.vaadin.testbench.internal.SharedUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ElementQuery<T extends TestBenchElement> {
    private static final int DEFAULT_WAIT_TIME_OUT_IN_SECONDS = 10;
    private static final String NULL_COMPARISON_MSG = "comparison must not be null";
    private static final String NULL_CONDITION_MSG = "condition must not be null";
    private static final String NULL_GETTER_MSG = "getter function must not be null";
    private static final String NULL_TEXT_MSG = "text must not be null";
    private final Class<T> elementClass;
    private final String tagName;
    private final Set<AttributeMatch> attributes;
    private final List<Predicate<T>> conditions;
    private SearchContext searchContext;

    public ElementQuery(Class<T> elementClass) {
        this(elementClass, ElementQuery.getTagName(elementClass));
    }

    public ElementQuery(Class<T> elementClass, String tagName) {
        this.elementClass = elementClass;
        this.tagName = tagName;
        this.attributes = new LinkedHashSet<AttributeMatch>(ElementQuery.getAttributes(elementClass));
        this.conditions = new ArrayList<Predicate<T>>();
    }

    @Deprecated(since="9.3")
    public ElementQuery<T> hasAttribute(String name) {
        return this.withAttribute(name);
    }

    @Deprecated(since="9.3")
    public ElementQuery<T> attribute(String name, String value) {
        return this.withAttribute(name, value);
    }

    @Deprecated(since="9.3")
    public ElementQuery<T> attributeContains(String name, String word) {
        return this.withAttributeContainingWord(name, word);
    }

    public ElementQuery<T> withAttribute(String attribute) {
        this.attributes.add(new AttributeMatch(attribute));
        return this;
    }

    public ElementQuery<T> withAttribute(String attribute, String value, AttributeMatch.Comparison comparison) {
        this.attributes.add(new AttributeMatch(attribute, comparison, value));
        return this;
    }

    public ElementQuery<T> withAttribute(String attribute, String value) {
        return this.withAttribute(attribute, value, AttributeMatch.Comparison.MATCHES_EXACTLY);
    }

    public ElementQuery<T> withAttributeContaining(String attribute, String text) {
        return this.withAttribute(attribute, text, AttributeMatch.Comparison.CONTAINS);
    }

    public ElementQuery<T> withAttributeContainingWord(String attribute, String word) {
        return this.withAttribute(attribute, word, AttributeMatch.Comparison.CONTAINS_WORD);
    }

    public ElementQuery<T> withoutAttribute(String attribute) {
        return this.withAttribute(attribute, null, AttributeMatch.Comparison.NOT_EXISTS);
    }

    public ElementQuery<T> withoutAttribute(String attribute, String value) {
        return this.withAttribute(attribute, value, AttributeMatch.Comparison.NOT_MATCHES_EXACTLY);
    }

    public ElementQuery<T> withoutAttributeContaining(String attribute, String text) {
        return this.withAttribute(attribute, text, AttributeMatch.Comparison.NOT_CONTAINS);
    }

    public ElementQuery<T> withoutAttributeContainingWord(String attribute, String word) {
        return this.withAttribute(attribute, word, AttributeMatch.Comparison.NOT_CONTAINS_WORD);
    }

    public ElementQuery<T> withId(String id) {
        return this.withAttribute("id", id);
    }

    public ElementQuery<T> withClassName(String ... classNames) {
        Arrays.stream(classNames).forEach(className -> this.withAttributeContainingWord("class", (String)className));
        return this;
    }

    public ElementQuery<T> withoutClassName(String ... classNames) {
        Arrays.stream(classNames).forEach(className -> this.withoutAttributeContainingWord("class", (String)className));
        return this;
    }

    public ElementQuery<T> withTheme(String theme) {
        return this.withAttribute("theme", theme);
    }

    public ElementQuery<T> withoutTheme(String theme) {
        return this.withoutAttribute("theme", theme);
    }

    public ElementQuery<T> withCondition(Predicate<T> condition) {
        Objects.requireNonNull(condition, NULL_CONDITION_MSG);
        this.conditions.add(condition);
        return this;
    }

    public <V> ElementQuery<T> withPropertyValue(Function<T, V> getter, V propertyValue, BiPredicate<V, V> comparison) {
        Objects.requireNonNull(getter, NULL_GETTER_MSG);
        Objects.requireNonNull(comparison, NULL_COMPARISON_MSG);
        return this.withCondition(element -> comparison.test(getter.apply(element), propertyValue));
    }

    public <V> ElementQuery<T> withPropertyValue(Function<T, V> getter, V propertyValue) {
        return this.withPropertyValue(getter, propertyValue, Objects::equals);
    }

    public ElementQuery<T> withLabel(String text, BiPredicate<String, String> comparison) {
        Objects.requireNonNull(text, NULL_TEXT_MSG);
        Objects.requireNonNull(comparison, NULL_COMPARISON_MSG);
        return this.withCondition(element -> {
            HasLabel hasLabel;
            return element instanceof HasLabel && comparison.test((hasLabel = (HasLabel)((Object)element)).getLabel(), text);
        });
    }

    public ElementQuery<T> withLabel(String label) {
        return this.withLabel(label, String::equals);
    }

    public ElementQuery<T> withLabelContaining(String text) {
        return this.withLabel(text, String::contains);
    }

    public ElementQuery<T> withPlaceholder(String text, BiPredicate<String, String> comparison) {
        Objects.requireNonNull(text, NULL_TEXT_MSG);
        Objects.requireNonNull(comparison, NULL_COMPARISON_MSG);
        return this.withCondition(element -> {
            HasPlaceholder hasPlaceholder;
            return element instanceof HasPlaceholder && comparison.test((hasPlaceholder = (HasPlaceholder)((Object)element)).getPlaceholder(), text);
        });
    }

    public ElementQuery<T> withPlaceholder(String placeholder) {
        return this.withPlaceholder(placeholder, String::equals);
    }

    public ElementQuery<T> withPlaceholderContaining(String text) {
        return this.withPlaceholder(text, String::contains);
    }

    public ElementQuery<T> withCaption(String text, BiPredicate<String, String> comparison) {
        Objects.requireNonNull(text, NULL_TEXT_MSG);
        Objects.requireNonNull(comparison, NULL_COMPARISON_MSG);
        return this.withCondition(element -> {
            HasLabelAsText labelAsText;
            HasPlaceholder hasPlaceholder;
            String placeholder;
            String label;
            HasLabel hasLabel;
            if (text.isEmpty() && element instanceof HasLabel) {
                hasLabel = (HasLabel)((Object)element);
                if (element instanceof HasPlaceholder) {
                    HasPlaceholder hasPlaceholder2 = (HasPlaceholder)((Object)element);
                    String label2 = hasLabel.getLabel();
                    String placeholder2 = hasPlaceholder2.getPlaceholder();
                    return label2.isEmpty() && placeholder2.isEmpty();
                }
            }
            if (element instanceof HasLabel && !(label = (hasLabel = (HasLabel)((Object)element)).getLabel()).isEmpty()) {
                return comparison.test(label, text);
            }
            if (element instanceof HasPlaceholder && !(placeholder = (hasPlaceholder = (HasPlaceholder)((Object)element)).getPlaceholder()).isEmpty()) {
                return comparison.test(placeholder, text);
            }
            if (element instanceof HasLabelAsText && !(label = Objects.requireNonNullElse((labelAsText = (HasLabelAsText)((Object)element)).getText(), "")).isEmpty()) {
                return comparison.test(label, text);
            }
            return false;
        });
    }

    public ElementQuery<T> withCaption(String caption) {
        return this.withCaption(caption, String::equals);
    }

    public ElementQuery<T> withCaptionContaining(String text) {
        return this.withCaption(text, String::contains);
    }

    public ElementQuery<T> withText(String text, BiPredicate<String, String> comparison) {
        Objects.requireNonNull(text, NULL_TEXT_MSG);
        Objects.requireNonNull(comparison, NULL_COMPARISON_MSG);
        return this.withCondition(element -> comparison.test(Objects.requireNonNullElse(element.getText(), ""), text));
    }

    public ElementQuery<T> withText(String text) {
        return this.withText(text, String::equals);
    }

    public ElementQuery<T> withTextContaining(String text) {
        return this.withText(text, String::contains);
    }

    public ElementQuery<T> context(SearchContext searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    public ElementQuery<T> onPage() {
        return this.context((SearchContext)this.getDriver());
    }

    protected SearchContext getContext() {
        return this.searchContext;
    }

    public T id(String id) {
        return this.withId(id).single();
    }

    public T single() {
        List<T> all = this.all();
        if (all.size() != 1) {
            throw new NoSuchElementException(this.getNoSuchElementMessage(null, all.size()));
        }
        return (T)((TestBenchElement)all.get(0));
    }

    public T first() {
        return this.get(0);
    }

    public T waitForFirst() {
        return this.waitForFirst(10L);
    }

    public T waitForFirst(long timeOutInSeconds) {
        TestBenchElement result = (TestBenchElement)new WebDriverWait(this.getDriver(), Duration.ofSeconds(timeOutInSeconds)).until(driver -> {
            try {
                return this.first();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        });
        if (result == null) {
            throw new NoSuchElementException(this.getNoSuchElementMessage(null));
        }
        return (T)result;
    }

    public T last() {
        List<T> all = this.all();
        if (all.isEmpty()) {
            throw new NoSuchElementException(this.getNoSuchElementMessage(null));
        }
        return (T)((TestBenchElement)all.get(all.size() - 1));
    }

    public T get(int index) {
        Objects.checkIndex(index, Integer.MAX_VALUE);
        if (this.conditions.isEmpty()) {
            List<T> elements = this.executeSearch(index);
            if (elements.isEmpty()) {
                throw new NoSuchElementException(this.getNoSuchElementMessage(index));
            }
            return (T)((TestBenchElement)elements.get(0));
        }
        List<T> elements = this.executeSearch(null);
        if (index >= elements.size()) {
            throw new NoSuchElementException(this.getNoSuchElementMessage(index));
        }
        return (T)((TestBenchElement)elements.get(index));
    }

    private String getNoSuchElementMessage(Integer index, int foundCount) {
        String msg = (String)(foundCount == 0 ? "No element" : "Multiple elements (" + foundCount + ")") + " with tag <" + this.tagName + "> found";
        String attrPairs = this.getAttributePairs();
        if (!attrPairs.isEmpty()) {
            msg = msg + " with the attributes " + attrPairs;
        }
        if (index != null) {
            msg = msg + " using index " + index;
        }
        return msg + ".";
    }

    private String getNoSuchElementMessage(Integer index) {
        return this.getNoSuchElementMessage(index, 0);
    }

    public boolean exists() {
        return !this.all().isEmpty();
    }

    public List<T> all() {
        return this.executeSearch(null);
    }

    private WebDriver getDriver() {
        SearchContext context = this.getContext();
        if (context instanceof WebDriver) {
            WebDriver webDriver = (WebDriver)context;
            return webDriver;
        }
        return ((TestBenchElement)context).getDriver();
    }

    private List<T> executeSearch(Integer index) {
        TestBenchDriverProxy executor;
        TestBenchElement elementContext;
        StringBuilder script = new StringBuilder();
        SearchContext context = this.getContext();
        if (context instanceof TestBenchElement) {
            TestBenchElement testBenchElement = (TestBenchElement)context;
            script.append("var result = [];if (arguments[0].shadowRoot) {  var shadow = arguments[0].shadowRoot.querySelectorAll(arguments[1]+arguments[2]);  result = result.concat(Array.prototype.slice.call(shadow));}var light = arguments[0].querySelectorAll(arguments[1]+arguments[2]);result = result.concat(Array.prototype.slice.call(light));return result");
            elementContext = testBenchElement;
            executor = elementContext.getCommandExecutor().getDriver();
        } else if (context instanceof WebDriver) {
            WebDriver webDriver = (WebDriver)context;
            script.append("var result = [];const queryResult = document.querySelectorAll(arguments[1]+arguments[2]);result = result.concat(Array.prototype.slice.call(queryResult));return result");
            elementContext = null;
            executor = (JavascriptExecutor)webDriver;
        } else {
            if (context == null) {
                throw new IllegalStateException("Context cannot be null");
            }
            throw new IllegalStateException("Unknown context type: " + context.getClass().getName());
        }
        if (index != null) {
            script.append("[").append(index).append("]");
        }
        return this.executeSearchScript(script.toString(), elementContext, this.tagName, this.getAttributePairs(), executor).stream().filter(this::satisfiesAllConditions).toList();
    }

    private boolean satisfiesAllConditions(T element) {
        return this.conditions.stream().allMatch(condition -> condition.test(element));
    }

    private static String getTagName(Class<?> elementClass) {
        Element annotation = elementClass.getAnnotation(Element.class);
        if (annotation == null) {
            throw new IllegalStateException("The given element class " + elementClass.getName() + " must be annotated using @" + Element.class.getName());
        }
        return annotation.value();
    }

    static Set<AttributeMatch> getAttributes(Class<? extends TestBenchElement> elementClass) {
        Attribute[] attrs = (Attribute[])elementClass.getAnnotationsByType(Attribute.class);
        if (attrs.length == 0) {
            return Collections.emptySet();
        }
        HashSet<AttributeMatch> classAttributes = new HashSet<AttributeMatch>();
        for (Attribute attr : attrs) {
            String value;
            ElementQuery.validateAttributeValues(attr);
            if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attr.value())) {
                value = attr.value().equals("THE_CONVENTION_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!") ? ElementQuery.getClassConventionValue(elementClass) : attr.value();
                classAttributes.add(new AttributeMatch(attr.name(), AttributeMatch.Comparison.MATCHES_EXACTLY, value));
                continue;
            }
            if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attr.contains())) {
                value = attr.contains().equals("THE_CONVENTION_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!") ? ElementQuery.getClassConventionValue(elementClass) : attr.contains();
                classAttributes.add(new AttributeMatch(attr.name(), AttributeMatch.Comparison.CONTAINS_WORD, value));
                continue;
            }
            if (!attr.exists()) {
                classAttributes.add(new AttributeMatch(attr.name(), false));
                continue;
            }
            classAttributes.add(new AttributeMatch(attr.name()));
        }
        return classAttributes;
    }

    private static String getClassConventionValue(Class<?> elementClass) {
        String value = elementClass.getSimpleName();
        value = value.replaceAll("(Element|PageObject)$", "");
        value = SharedUtil.camelCaseToDashSeparated(value).replaceAll("^-*", "");
        return value;
    }

    private String getAttributePairs() {
        return this.attributes.stream().map(AttributeMatch::getExpression).collect(Collectors.joining());
    }

    List<T> executeSearchScript(String script, Object context, String tagName, String attributePairs, JavascriptExecutor executor) {
        Object result = executor.executeScript(script, new Object[]{context, tagName, attributePairs});
        if (result == null) {
            return Collections.emptyList();
        }
        if (result instanceof TestBenchElement) {
            TestBenchElement testBenchElement = (TestBenchElement)result;
            return Collections.singletonList(TestBench.wrap(testBenchElement, this.elementClass));
        }
        List elements = (List)result;
        elements.replaceAll(element -> TestBench.wrap(element, this.elementClass));
        return elements;
    }

    private static void validateAttributeValues(Attribute attribute) {
        String annotationName = Attribute.class.getSimpleName();
        if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attribute.value())) {
            if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attribute.contains())) {
                throw new RuntimeException("You can only define either 'contains' or 'value' for an @" + annotationName);
            }
            if (!attribute.exists()) {
                throw new RuntimeException("You can only define 'value' with 'exists=true' for an @" + annotationName);
            }
        } else if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attribute.contains()) && !attribute.exists()) {
            throw new RuntimeException("You can only define 'contains' with 'exists=true' for an @" + annotationName);
        }
    }

    public static class AttributeMatch {
        private final String name;
        private final Comparison comparison;
        private final String value;

        public AttributeMatch(String name, Comparison comparison, String value) {
            this.name = name;
            this.comparison = comparison;
            this.value = value;
        }

        @Deprecated(forRemoval=true, since="9.3")
        public AttributeMatch(String name, String operator, String value) {
            this(name, Arrays.stream(Comparison.values()).filter(comp -> comp.getOperator().equals(operator)).findFirst().orElseThrow(() -> new java.util.NoSuchElementException("Invalid operator \"" + operator + "\" supplied. As this constructor is unsafe and deprecated, please use AttributeMatch(String, Comparison, String) instead.")), value);
        }

        public AttributeMatch(String name, String value) {
            this(name, Comparison.MATCHES_EXACTLY, value);
        }

        public AttributeMatch(String name) {
            this(name, true);
        }

        public AttributeMatch(String name, boolean exists) {
            this(name, exists ? Comparison.EXISTS : Comparison.NOT_EXISTS, null);
        }

        public String toString() {
            return this.getExpression();
        }

        public String getExpression() {
            return this.comparison.expressionFor(this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttributeMatch)) {
                return false;
            }
            return this.getExpression().equals(((AttributeMatch)obj).getExpression());
        }

        public int hashCode() {
            return this.getExpression().hashCode();
        }

        public static enum Comparison {
            EXISTS(""),
            MATCHES_EXACTLY("="),
            CONTAINS("*="),
            CONTAINS_WORD("~="),
            CONTAINS_PREFIX("|="),
            BEGINS_WITH("^="),
            ENDS_WITH("$="),
            NOT_EXISTS(Comparison.EXISTS.operator, true),
            NOT_MATCHES_EXACTLY(Comparison.MATCHES_EXACTLY.operator, true),
            NOT_CONTAINS(Comparison.CONTAINS.operator, true),
            NOT_CONTAINS_WORD(Comparison.CONTAINS_WORD.operator, true),
            NOT_CONTAINS_PREFIX(Comparison.CONTAINS_PREFIX.operator, true),
            NOT_BEGINS_WITH(Comparison.BEGINS_WITH.operator, true),
            NOT_ENDS_WITH(Comparison.ENDS_WITH.operator, true);

            private final String operator;
            private final boolean negated;

            private Comparison(String operator, boolean negated) {
                this.operator = operator;
                this.negated = negated;
            }

            private Comparison(String operator) {
                this(operator, false);
            }

            public String getOperator() {
                return this.operator;
            }

            public boolean isNegated() {
                return this.negated;
            }

            public String expressionFor(String name, String value) {
                Object expression = name;
                if (value != null) {
                    expression = (String)expression + this.getOperator() + "'" + Comparison.escapeAttributeValue(value) + "'";
                }
                expression = "[" + (String)expression + "]";
                if (this.isNegated()) {
                    expression = ":not(" + (String)expression + ")";
                }
                return expression;
            }

            private static String escapeAttributeValue(String value) {
                return value.replace("'", "\\'");
            }
        }
    }
}

