/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.parallel.ExcludeFromSuite;
import com.vaadin.testbench.parallel.ParallelScheduler;
import com.vaadin.testbench.parallel.ParallelTest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class ParallelTestSuite
extends Suite {
    private static final int MAX_CONCURRENT_TEST_SUITES = Parameters.getTestSuitesInParallel();
    private final ExecutorService service = Executors.newFixedThreadPool(MAX_CONCURRENT_TEST_SUITES);

    public ParallelTestSuite(Class<?> klass, Class<? extends ParallelTest> baseClass, String basePackage, String[] ignorePackages) throws InitializationError {
        this(klass, ParallelTestSuite.findTests(baseClass, basePackage, ignorePackages));
    }

    protected ParallelTestSuite(Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(klass, (Class[])suiteClasses);
        this.setScheduler(new ParallelScheduler(this.service));
    }

    private static Class<?>[] findTests(Class<? extends ParallelTest> baseClass, String basePackage, String[] ignorePackages) {
        try {
            List<Class<? extends ParallelTest>> l = ParallelTestSuite.findClasses(baseClass, basePackage, ignorePackages);
            return l.toArray(new Class[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> List<Class<? extends T>> findClasses(Class<T> baseClass, String basePackage, String[] ignoredPackages) throws IOException {
        ArrayList<Class<? extends T>> classes = new ArrayList<Class<? extends T>>();
        String basePackageDirName = "/" + basePackage.replace('.', '/');
        URL location = baseClass.getResource(basePackageDirName);
        if (location.getProtocol().equals("file")) {
            try {
                File f = new File(location.toURI());
                if (!f.exists()) {
                    throw new IOException("Directory " + f.toString() + " does not exist");
                }
                ParallelTestSuite.findPackages(f, basePackage, baseClass, classes, ignoredPackages);
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        } else if (location.getProtocol().equals("jar")) {
            JarURLConnection juc = (JarURLConnection)location.openConnection();
            ParallelTestSuite.findClassesInJar(juc, basePackage, baseClass, classes);
        }
        Collections.sort(classes, new Comparator<Class<? extends T>>(){

            @Override
            public int compare(Class<? extends T> o1, Class<? extends T> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return classes;
    }

    private static <T> void findPackages(File parent, String javaPackage, Class<T> baseClass, Collection<Class<? extends T>> result, String[] ignoredPackages) {
        for (String ignoredPackage : ignoredPackages) {
            if (!javaPackage.equals(ignoredPackage)) continue;
            return;
        }
        for (File file : parent.listFiles()) {
            if (file.isDirectory()) {
                ParallelTestSuite.findPackages(file, javaPackage + "." + file.getName(), baseClass, result, ignoredPackages);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String fullyQualifiedClassName = javaPackage + "." + file.getName().replace(".class", "");
            ParallelTestSuite.addClassIfMatches(result, fullyQualifiedClassName, baseClass);
        }
    }

    private static <T> void findClassesInJar(JarURLConnection juc, String javaPackage, Class<T> baseClass, Collection<Class<? extends T>> result) throws IOException {
        String javaPackageDir = javaPackage.replace('.', '/');
        Enumeration<JarEntry> ent = juc.getJarFile().entries();
        while (ent.hasMoreElements()) {
            JarEntry e = ent.nextElement();
            if (!e.getName().endsWith(".class") || !e.getName().startsWith(javaPackageDir)) continue;
            String fullyQualifiedClassName = e.getName().replace('/', '.').replace(".class", "");
            ParallelTestSuite.addClassIfMatches(result, fullyQualifiedClassName, baseClass);
        }
    }

    private static <T> void addClassIfMatches(Collection<Class<? extends T>> result, String fullyQualifiedClassName, Class<T> baseClass) {
        try {
            Class<?> c = Class.forName(fullyQualifiedClassName);
            if (!baseClass.isAssignableFrom(c)) {
                return;
            }
            if (!ParallelTestSuite.includeInSuite(c)) {
                return;
            }
            if (!Modifier.isAbstract(c.getModifiers()) && !c.isAnonymousClass()) {
                result.add(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private static boolean includeInSuite(Class<?> c) {
        return c.getAnnotation(ExcludeFromSuite.class) == null;
    }
}

