/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.HasElementQuery;
import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.RetryRule;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.commands.TestBenchCommands;
import java.time.Duration;
import java.util.List;
import org.junit.Rule;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestBenchTestCase
implements HasDriver,
HasTestBenchCommandExecutor,
HasElementQuery {
    @Rule
    public RetryRule maxAttempts = new RetryRule(Parameters.getMaxAttempts());
    protected WebDriver driver;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TestBenchTestCase.class);
    }

    public TestBenchCommands testBench() {
        return ((TestBenchDriverProxy)this.getDriver()).getCommandExecutor();
    }

    protected String concatUrl(String baseUrl, String uri) {
        if (baseUrl.endsWith("/") && uri.startsWith("/")) {
            return baseUrl + uri.substring(1);
        }
        return baseUrl + uri;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        if (driver != null && !(driver instanceof TestBenchDriverProxy)) {
            driver = TestBench.createDriver((WebDriver)driver);
        }
        this.driver = driver;
    }

    public SearchContext getContext() {
        return this.getDriver();
    }

    public TestBenchCommandExecutor getCommandExecutor() {
        return ((HasTestBenchCommandExecutor)this.getDriver()).getCommandExecutor();
    }

    public WebElement findElement(By by) {
        return this.getContext().findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.getContext().findElements(by);
    }

    public <T extends TestBenchElement> T wrap(Class<T> elementType, WebElement element) {
        return (T)((TestBenchElement)element).wrap(elementType);
    }

    protected Object executeScript(String script, Object ... args) {
        return this.getCommandExecutor().executeScript(script, args);
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition, long timeoutInSeconds) {
        return (T)new WebDriverWait(this.getDriver(), Duration.ofSeconds(timeoutInSeconds)).until(condition);
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition) {
        return this.waitUntil(condition, 10L);
    }

    static {
        TestBench.ensureLoaded();
    }
}

