/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.screenshot;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageUtil {
    public static String encodeImageToBase64(BufferedImage image) {
        String encodedImage = "";
        Base64 encoder = new Base64();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            baos.flush();
            byte[] encodedBytes = encoder.encode(baos.toByteArray());
            encodedImage = new String(encodedBytes);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return encodedImage;
    }

    public static double getLuminance(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return ImageUtil.getLuminance(r, g, b);
    }

    private static double getLuminance(int r, int g, int b) {
        return 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
    }

    public static boolean imagesSameSize(BufferedImage image1, BufferedImage image2) {
        return image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight();
    }

    public static List<BufferedImage> cropToBeSameSize(BufferedImage image1, BufferedImage image2) {
        if (ImageUtil.imagesSameSize(image1, image2)) {
            return Arrays.asList(image1, image2);
        }
        int minHeight = Math.min(image1.getHeight(), image2.getHeight());
        int minWidth = Math.min(image1.getWidth(), image2.getWidth());
        BufferedImage cropped1 = ImageUtil.cropImage(image1, minWidth, minHeight);
        BufferedImage cropped2 = ImageUtil.cropImage(image2, minWidth, minHeight);
        return Arrays.asList(cropped1, cropped2);
    }

    private static BufferedImage cropImage(BufferedImage image, int width, int height) {
        if (image.getWidth() == width && image.getHeight() == height) {
            return image;
        }
        return image.getSubimage(0, 0, width, height);
    }

    public static final int[] createSampleBuffer() {
        return new int[1024];
    }

    public static final ImageProperties getImageProperties(BufferedImage image) {
        int imageType = image.getType();
        ImageProperties p = new ImageProperties();
        p.image = image;
        p.raster = image.getRaster();
        p.alpha = imageType == 2 || imageType == 6;
        boolean rgb = imageType == 2 || imageType == 1;
        boolean bgr = imageType == 4 || imageType == 5 || imageType == 6;
        p.width = image.getWidth();
        p.height = image.getHeight();
        p.fallback = !rgb && !bgr;
        return p;
    }

    public static final int[] getBlock(ImageProperties properties, int x, int y, int[] result, int[] sample) {
        if (result == null) {
            result = new int[256];
        }
        if (sample == null) {
            sample = new int[1024];
        }
        int width = x + 16 >= properties.width ? properties.width - x : 16;
        int height = y + 16 >= properties.height ? properties.height - y : 16;
        int l = width * height;
        if (properties.fallback) {
            properties.image.getRGB(x, y, width, height, result, 0, width);
        } else {
            int i;
            int p;
            properties.raster.getPixels(x, y, width, height, sample);
            if (properties.alpha) {
                p = 0;
                for (i = 0; i < l; ++i) {
                    result[i] = sample[p + 3] << 24 | sample[p] << 16 | sample[p + 1] << 8 | sample[p + 2];
                    p += 4;
                }
            } else {
                p = 0;
                for (i = 0; i < l; ++i) {
                    result[i] = 0xFF000000 | sample[p] << 16 | sample[p + 1] << 8 | sample[p + 2];
                    p += 3;
                }
            }
        }
        int max = result.length;
        for (int i = l; i < max; ++i) {
            result[i] = 0;
        }
        return result;
    }

    public static BufferedImage cloneImage(BufferedImage sourceImage) {
        int w = sourceImage.getWidth();
        int h = sourceImage.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 1);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.drawImage(sourceImage, 0, 0, w, h, null);
        g.dispose();
        return newImage;
    }

    public static class ImageProperties {
        private BufferedImage image = null;
        private Raster raster = null;
        private boolean alpha = false;
        private boolean fallback = false;
        private int width = 0;
        private int height = 0;
    }
}

