/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasTestBenchCommandExecutor;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;

public class TestBenchDriverProxy
implements WebDriver,
WrapsDriver,
HasTestBenchCommandExecutor,
HasCapabilities,
TakesScreenshot,
JavascriptExecutor {
    private final WebDriver wrappedDriver;
    private final TestBenchCommandExecutor commandExecutor;

    protected TestBenchDriverProxy(WebDriver webDriver, TestBenchCommandExecutor commandExecutor) {
        this.wrappedDriver = webDriver;
        this.commandExecutor = commandExecutor;
    }

    public void close() {
        this.getWrappedDriver().close();
    }

    public WebElement findElement(By arg0) {
        return TestBenchElement.wrapElement(this.wrappedDriver.findElement(arg0), this.getCommandExecutor());
    }

    public List<WebElement> findElements(By arg0) {
        return TestBenchElement.wrapElements(this.wrappedDriver.findElements(arg0), this.getCommandExecutor());
    }

    public void get(String arg0) {
        this.wrappedDriver.get(arg0);
    }

    public String getCurrentUrl() {
        return this.wrappedDriver.getCurrentUrl();
    }

    public String getPageSource() {
        return this.wrappedDriver.getPageSource();
    }

    public String getTitle() {
        return this.wrappedDriver.getTitle();
    }

    public String getWindowHandle() {
        return this.wrappedDriver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.wrappedDriver.getWindowHandles();
    }

    public WebDriver.Options manage() {
        return this.wrappedDriver.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.wrappedDriver.navigate();
    }

    public void quit() {
        this.wrappedDriver.quit();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.wrappedDriver.switchTo();
    }

    @Override
    public TestBenchCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public Capabilities getCapabilities() {
        if (this.wrappedDriver instanceof HasCapabilities) {
            return ((HasCapabilities)this.wrappedDriver).getCapabilities();
        }
        return null;
    }

    public WebDriver getWrappedDriver() {
        return this.wrappedDriver;
    }

    protected static Object wrapElementOrElements(Object elementElementsOrValues, TestBenchCommandExecutor tbCommandExecutor) {
        if (elementElementsOrValues instanceof List) {
            List list = (List)elementElementsOrValues;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object value : list) {
                newList.add(TestBenchDriverProxy.wrapElementOrElements(value, tbCommandExecutor));
            }
            return newList;
        }
        if (elementElementsOrValues instanceof WebElement) {
            if (elementElementsOrValues instanceof TestBenchElement) {
                return elementElementsOrValues;
            }
            return TestBench.createElement((WebElement)elementElementsOrValues, tbCommandExecutor);
        }
        return elementElementsOrValues;
    }

    public Object executeScript(String script, Object ... args) {
        if (!(this.getWrappedDriver() instanceof JavascriptExecutor)) {
            throw new RuntimeException("The driver is not a JavascriptExecutor");
        }
        return TestBenchDriverProxy.wrapElementOrElements(((JavascriptExecutor)this.getWrappedDriver()).executeScript(script, args), this.getCommandExecutor());
    }

    public Object executeAsyncScript(String script, Object ... args) {
        if (!(this.getWrappedDriver() instanceof JavascriptExecutor)) {
            throw new RuntimeException("The driver is not a JavascriptExecutor");
        }
        return TestBenchDriverProxy.wrapElementOrElements(((JavascriptExecutor)this.getWrappedDriver()).executeAsyncScript(script, args), this.getCommandExecutor());
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)((TakesScreenshot)this.getWrappedDriver()).getScreenshotAs(target);
    }
}

