/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.screenshot;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.screenshot.ReferenceNameGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.openqa.selenium.Capabilities;

public class ImageFileUtil {
    private static ImageFileUtilImpl impl = new ImageFileUtilImpl();

    public static String getScreenshotReferenceDirectory() {
        return impl.getScreenshotReferenceDirectory();
    }

    public static String getScreenshotErrorDirectory() {
        return impl.getScreenshotErrorDirectory();
    }

    public static void createScreenshotDirectoriesIfNeeded() {
        impl.createScreenshotDirectoriesIfNeeded();
    }

    public static BufferedImage readReferenceImage(String referenceImageFileName) throws IOException {
        return impl.readReferenceImage(referenceImageFileName);
    }

    public static File getErrorScreenshotFile(String errorImageFileName) {
        return impl.getErrorScreenshotFile(errorImageFileName);
    }

    public static File getReferenceScreenshotFile(String referenceImageFileName) {
        return impl.getReferenceScreenshotFile(referenceImageFileName);
    }

    public static List<String> getReferenceImageFileNames(String referenceImageFileName, Capabilities capabilities) {
        return impl.getReferenceImageFileNames(referenceImageFileName, capabilities);
    }

    public static class ImageFileUtilImpl {
        public String getScreenshotReferenceDirectory() {
            return Parameters.getScreenshotReferenceDirectory();
        }

        public String getScreenshotErrorDirectory() {
            return Parameters.getScreenshotErrorDirectory();
        }

        public void createScreenshotDirectoriesIfNeeded() {
            File dir;
            if (this.getScreenshotReferenceDirectory() != null && !(dir = new File(this.getScreenshotReferenceDirectory())).exists()) {
                dir.mkdirs();
            }
            if (this.getScreenshotErrorDirectory() != null) {
                dir = new File(this.getScreenshotErrorDirectory());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (Parameters.isDebug()) {
                    dir = new File(this.getScreenshotErrorDirectory(), "diff");
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if (!(dir = new File(this.getScreenshotErrorDirectory(), "logs")).exists()) {
                        dir.mkdir();
                    }
                }
            }
        }

        public BufferedImage readReferenceImage(String referenceImageFileName) throws IOException {
            return ImageIO.read(this.getReferenceScreenshotFile(referenceImageFileName));
        }

        public File getErrorScreenshotFile(String errorImageFileName) {
            return new File(this.getScreenshotErrorDirectory(), errorImageFileName);
        }

        public File getReferenceScreenshotFile(String referenceImageFileName) {
            return new File(this.getScreenshotReferenceDirectory(), referenceImageFileName);
        }

        public List<String> getReferenceImageFileNames(String referenceImageFileName, Capabilities capabilities) {
            ArrayList<String> referenceImages = new ArrayList<String>();
            String actualName = this.findActualFileName(referenceImageFileName, capabilities);
            if (this.getReferenceScreenshotFile(actualName).exists()) {
                referenceImages.add(actualName);
            }
            for (int alternativeId = 1; alternativeId < 100; ++alternativeId) {
                String originalNameAlternative = referenceImageFileName.replace(".png", String.format("_%d.png", alternativeId));
                String actualNameAlternative = actualName.replace(".png", String.format("_%d.png", alternativeId));
                boolean origAlternativeFound = this.getReferenceScreenshotFile(originalNameAlternative).exists();
                boolean actualAlternativeFound = this.getReferenceScreenshotFile(actualNameAlternative).exists();
                if (origAlternativeFound) {
                    referenceImages.add(originalNameAlternative);
                }
                if (actualAlternativeFound) {
                    referenceImages.add(actualNameAlternative);
                }
                if (!origAlternativeFound && !actualAlternativeFound) break;
            }
            return referenceImages;
        }

        private String findActualFileName(String referenceFileName, Capabilities cap) {
            if (cap == null) {
                return referenceFileName;
            }
            String fileName = this.findOldReferenceScreenshot(cap.getBrowserName(), Integer.valueOf(ReferenceNameGenerator.getMajorVersion(cap)), referenceFileName);
            return fileName;
        }

        String findOldReferenceScreenshot(String browserName, int browserVersion, String fileName) {
            String newFileName = new String(fileName);
            if (!ImageFileUtil.getReferenceScreenshotFile(fileName).exists()) {
                String navigatorId = browserName + "_" + browserVersion;
                int nextVersion = browserVersion;
                String fileNameTemplate = fileName.replace(navigatorId, "####");
                while (!ImageFileUtil.getReferenceScreenshotFile(newFileName = fileNameTemplate.replace("####", String.format("%s_%d", browserName, --nextVersion))).exists() && nextVersion > 0) {
                }
                if (nextVersion == 0) {
                    newFileName = fileName;
                }
            }
            return newFileName;
        }
    }
}

