/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.screenshot.ImageFileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotOnFailureExtension
implements TestWatcher {
    private HasDriver driverHolder;
    private boolean quitDriverOnFinish = false;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ScreenshotOnFailureExtension.class);
    }

    public ScreenshotOnFailureExtension(HasDriver driverHolder) {
        this.driverHolder = driverHolder;
    }

    public ScreenshotOnFailureExtension(HasDriver driverHolder, boolean quitDriverOnFinish) {
        this.driverHolder = driverHolder;
        this.quitDriverOnFinish = quitDriverOnFinish;
    }

    public void setQuitDriverOnFinish(boolean quitDriverOnFinish) {
        this.quitDriverOnFinish = quitDriverOnFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailed(ExtensionContext context, Throwable cause) {
        if (this.driverHolder.getDriver() == null) {
            return;
        }
        WebDriver realDriver = this.driverHolder.getDriver();
        while (realDriver instanceof WrapsDriver) {
            realDriver = ((WrapsDriver)realDriver).getWrappedDriver();
        }
        if (realDriver instanceof RemoteWebDriver && ((RemoteWebDriver)realDriver).getSessionId() == null) {
            ScreenshotOnFailureExtension.getLogger().warn("Unable capture failure screenshot: web driver is no longer available");
            return;
        }
        try {
            BufferedImage screenshotImage = ImageIO.read(new ByteArrayInputStream((byte[])((TakesScreenshot)this.driverHolder.getDriver()).getScreenshotAs(OutputType.BYTES)));
            ImageFileUtil.createScreenshotDirectoriesIfNeeded();
            File errorScreenshotFile = this.getErrorScreenshotFile(context);
            ImageIO.write((RenderedImage)screenshotImage, "png", errorScreenshotFile);
            ScreenshotOnFailureExtension.getLogger().info("Error screenshot written to: " + errorScreenshotFile.getAbsolutePath());
        }
        catch (Exception e) {
            ScreenshotOnFailureExtension.getLogger().warn("Unable to capture failure screenshot: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.quitDriverOnFinish();
        }
    }

    public void testSuccessful(ExtensionContext context) {
        this.quitDriverOnFinish();
    }

    private void quitDriverOnFinish() {
        if (this.quitDriverOnFinish && this.driverHolder != null && this.driverHolder.getDriver() != null) {
            try {
                this.driverHolder.getDriver().quit();
            }
            catch (Exception e) {
                ScreenshotOnFailureExtension.getLogger().warn("Unable to quit driver: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected File getErrorScreenshotFile(ExtensionContext context) {
        return ImageFileUtil.getErrorScreenshotFile((String)(this.fullDisplayName(context) + ".png"));
    }

    private String fullDisplayName(ExtensionContext context) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(context.getDisplayName());
        while (context.getParent().isPresent()) {
            context = (ExtensionContext)context.getParent().get();
            names.add(0, context.getDisplayName());
        }
        return String.join((CharSequence)"_", names);
    }
}

