/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.browser;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.annotations.BrowserConfiguration;
import com.vaadin.testbench.annotations.BrowserFactory;
import com.vaadin.testbench.annotations.RunLocally;
import com.vaadin.testbench.browser.BrowserExtension;
import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import com.vaadin.testbench.parallel.TestCategory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesUtil {
    private static Logger getLogger() {
        return LoggerFactory.getLogger(CapabilitiesUtil.class);
    }

    public static Collection<DesiredCapabilities> getDesiredCapabilities(ExtensionContext context) {
        if (CapabilitiesUtil.testRunsLocally(context)) {
            ArrayList<DesiredCapabilities> desiredCapabilities = new ArrayList<DesiredCapabilities>();
            Class javaTestClass = context.getRequiredTestClass();
            desiredCapabilities.add(BrowserUtil.getBrowserFactory().create(CapabilitiesUtil.getRunLocallyBrowserName(javaTestClass), CapabilitiesUtil.getRunLocallyBrowserVersion(javaTestClass)));
            return desiredCapabilities;
        }
        return CapabilitiesUtil.getFilteredCapabilities(context);
    }

    public static ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Collection<DesiredCapabilities> desiredCapabilities = CapabilitiesUtil.getDesiredCapabilities(context);
        if (desiredCapabilities.isEmpty() || CapabilitiesUtil.categoryIsExcludedOrNotExcplicitlyIncluded(context)) {
            return ConditionEvaluationResult.disabled((String)"Desired capabilities not present.");
        }
        if (BrowserExtension.isParameterizedTest(context) && desiredCapabilities.size() > 1) {
            return ConditionEvaluationResult.disabled((String)"@ParameterizedBrowserTest does not support multiple capabilities.");
        }
        return ConditionEvaluationResult.enabled((String)"Desired capabilities present.");
    }

    private static boolean categoryIsExcludedOrNotExcplicitlyIncluded(ExtensionContext context) {
        Class c = context.getRequiredTestClass();
        if (CapabilitiesUtil.categoryIsExcluded(c)) {
            return true;
        }
        if (CapabilitiesUtil.explicitInclusionIsUsed()) {
            return !CapabilitiesUtil.categoryIsIncluded(c);
        }
        return false;
    }

    private static boolean categoryIsIncluded(Class<?> c) {
        String include = System.getProperty("categories.include");
        if (include != null && include.trim().length() > 0) {
            return CapabilitiesUtil.hasCategoryFor(c, include.toLowerCase().trim());
        }
        return false;
    }

    private static boolean explicitInclusionIsUsed() {
        String include = System.getProperty("categories.include");
        return include != null && include.trim().length() > 0;
    }

    private static boolean categoryIsExcluded(Class<?> c) {
        String exclude = System.getProperty("categories.exclude");
        if (exclude != null && exclude.trim().length() > 0) {
            return CapabilitiesUtil.hasCategoryFor(c, exclude.toLowerCase().trim());
        }
        return false;
    }

    private static boolean hasCategoryFor(Class<?> c, String searchString) {
        if (CapabilitiesUtil.hasCategory(c)) {
            return searchString.contains(CapabilitiesUtil.getCategory(c).toLowerCase());
        }
        return false;
    }

    private static boolean hasCategory(Class<?> c) {
        return c.getAnnotation(TestCategory.class) != null;
    }

    private static String getCategory(Class<?> c) {
        return c.getAnnotation(TestCategory.class).value();
    }

    public static Browser getRunLocallyBrowserName(Class<?> testClass) {
        String runLocallyBrowserName = Parameters.getRunLocallyBrowserName();
        if (runLocallyBrowserName != null) {
            return Browser.valueOf((String)runLocallyBrowserName.toUpperCase());
        }
        RunLocally runLocally = testClass.getAnnotation(RunLocally.class);
        if (runLocally == null) {
            return null;
        }
        return runLocally.value();
    }

    public static String getRunLocallyBrowserVersion(Class<?> testClass) {
        String runLocallyBrowserVersion = Parameters.getRunLocallyBrowserVersion();
        if (runLocallyBrowserVersion != null) {
            return runLocallyBrowserVersion;
        }
        RunLocally runLocally = testClass.getAnnotation(RunLocally.class);
        if (runLocally == null) {
            return "";
        }
        return runLocally.version();
    }

    private static boolean testRunsLocally(ExtensionContext context) {
        if (Parameters.getRunLocallyBrowserName() != null) {
            return true;
        }
        RunLocally runLocally = context.getRequiredTestClass().getAnnotation(RunLocally.class);
        return runLocally != null;
    }

    private static Collection<DesiredCapabilities> getFilteredCapabilities(ExtensionContext context) {
        Collection<DesiredCapabilities> desiredCapabilites = CapabilitiesUtil.getBrowsersConfiguration(context);
        ArrayList<DesiredCapabilities> filteredCapabilities = new ArrayList<DesiredCapabilities>();
        String include = System.getProperty("browsers.include");
        String exclude = System.getProperty("browsers.exclude");
        for (DesiredCapabilities d : desiredCapabilites) {
            String browserName = (d.getBrowserName() + d.getBrowserVersion()).toLowerCase();
            if (include != null && include.trim().length() > 0) {
                if (include.trim().toLowerCase().contains(browserName)) {
                    filteredCapabilities.add(d);
                }
            } else {
                filteredCapabilities.add(d);
            }
            if (exclude == null || exclude.trim().length() <= 0 || !exclude.trim().toLowerCase().contains(browserName)) continue;
            filteredCapabilities.remove(d);
        }
        return filteredCapabilities;
    }

    private static Collection<DesiredCapabilities> getBrowsersConfiguration(ExtensionContext context) {
        block2: for (Class klass = context.getRequiredTestClass(); klass != null; klass = klass.getSuperclass()) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = klass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(BrowserConfiguration.class)) continue;
                boolean methodSignatureIsValid = CapabilitiesUtil.validateBrowserConfigurationAnnotatedSignature(method);
                if (!methodSignatureIsValid) continue block2;
                try {
                    return (Collection)method.invoke(CapabilitiesUtil.getTestClassInstance(context), new Object[0]);
                }
                catch (Exception e) {
                    String errMsg = String.format("Error occurred while invoking BrowserConfiguration method %s.%s(). Method was ignored, searching BrowserConfiguration method in superclasses", method.getDeclaringClass().getName(), method.getName());
                    CapabilitiesUtil.getLogger().info(errMsg, (Throwable)e);
                    continue block2;
                }
            }
        }
        return CapabilitiesUtil.getBrowserConfigurationFromParameterOrDefault();
    }

    private static List<DesiredCapabilities> getBrowserConfigurationFromParameterOrDefault() {
        if (Parameters.getGridBrowsers().isEmpty()) {
            return CapabilitiesUtil.getDefaultCapabilities();
        }
        return Parameters.getGridBrowsers();
    }

    public static List<DesiredCapabilities> getDefaultCapabilities() {
        return Collections.singletonList(BrowserUtil.chrome());
    }

    private static boolean validateBrowserConfigurationAnnotatedSignature(Method method) {
        String genericErrorMessage = "Error occurred while invoking BrowserConfigurationMethod %s.%s(). %s. Method was ignored, searching BrowserConfiguration method in superclasses";
        if (method.getParameterTypes().length != 0) {
            String errMsg = String.format(genericErrorMessage, method.getDeclaringClass().getName(), method.getName(), "BrowserConfiguration annotated method must not require any arguments");
            CapabilitiesUtil.getLogger().info(errMsg);
            return false;
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType())) {
            String errMsg = String.format(genericErrorMessage, method.getDeclaringClass().getName(), method.getName(), "BrowserConfiguration annotated method must return a Collection<DesiredCapabilities>");
            CapabilitiesUtil.getLogger().info(errMsg);
            return false;
        }
        return true;
    }

    private static Object getTestClassInstance(ExtensionContext context) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return context.getTestInstance().orElse(context.getRequiredTestClass().getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public static String getUniqueIdentifier(Capabilities capabilities) {
        String platform = BrowserUtil.getPlatform((Capabilities)capabilities);
        String browser = BrowserUtil.getBrowserIdentifier((Capabilities)capabilities);
        String version = capabilities == null ? "Unknown" : capabilities.getBrowserVersion();
        return platform + "_" + browser + "_" + version;
    }

    public static TestBenchBrowserFactory getBrowserFactory(ExtensionContext context) {
        BrowserFactory browserFactoryAnnotation = context.getRequiredTestClass().getAnnotation(BrowserFactory.class);
        try {
            if (browserFactoryAnnotation != null && TestBenchBrowserFactory.class.isAssignableFrom(browserFactoryAnnotation.value())) {
                return (TestBenchBrowserFactory)browserFactoryAnnotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DefaultBrowserFactory();
    }
}

