/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.testbench.elements;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.Tree")
@Deprecated
public class TreeElement extends AbstractSelectElement {
    /**
     * Returns selected item of the tree. In multiselect mode returns first
     * selected item. If there is no selected item returns empty string
     *
     * @return selected item of the tree
     */
    public String getValue() {
        List<WebElement> selectedElements = findElements(
                By.className("v-tree-node-selected"));
        if (selectedElements.isEmpty()) {
            return "";
        } else {
            return selectedElements.get(0).getText();
        }
    }
}
